/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert.comparator;

import wiremock.org.json.JSONArray;
import wiremock.org.json.JSONException;
import wiremock.org.json.JSONObject;
import wiremock.org.skyscreamer.jsonassert.JSONCompareMode;
import wiremock.org.skyscreamer.jsonassert.JSONCompareResult;
import wiremock.org.skyscreamer.jsonassert.comparator.AbstractComparator;
import wiremock.org.skyscreamer.jsonassert.comparator.JSONCompareUtil;

public class DefaultComparator
extends AbstractComparator {
    JSONCompareMode mode;

    public DefaultComparator(JSONCompareMode mode) {
        this.mode = mode;
    }

    @Override
    public void compareJSON(String prefix, JSONObject expected, JSONObject actual, JSONCompareResult result) throws JSONException {
        this.checkJsonObjectKeysExpectedInActual(prefix, expected, actual, result);
        if (!this.mode.isExtensible()) {
            this.checkJsonObjectKeysActualInExpected(prefix, expected, actual, result);
        }
    }

    @Override
    public void compareValues(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) throws JSONException {
        if (expectedValue instanceof Number && actualValue instanceof Number) {
            if (((Number)expectedValue).doubleValue() != ((Number)actualValue).doubleValue()) {
                result.fail(prefix, expectedValue, actualValue);
            }
        } else if (expectedValue.getClass().isAssignableFrom(actualValue.getClass())) {
            if (expectedValue instanceof JSONArray) {
                this.compareJSONArray(prefix, (JSONArray)expectedValue, (JSONArray)actualValue, result);
            } else if (expectedValue instanceof JSONObject) {
                this.compareJSON(prefix, (JSONObject)expectedValue, (JSONObject)actualValue, result);
            } else if (!expectedValue.equals(actualValue)) {
                result.fail(prefix, expectedValue, actualValue);
            }
        } else {
            result.fail(prefix, expectedValue, actualValue);
        }
    }

    @Override
    public void compareJSONArray(String prefix, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        if (expected.length() != actual.length()) {
            result.fail(prefix + "[]: Expected " + expected.length() + " values but got " + actual.length());
            return;
        }
        if (expected.length() == 0) {
            return;
        }
        if (this.mode.hasStrictOrder()) {
            this.compareJSONArrayWithStrictOrder(prefix, expected, actual, result);
        } else if (JSONCompareUtil.allSimpleValues(expected)) {
            this.compareJSONArrayOfSimpleValues(prefix, expected, actual, result);
        } else if (JSONCompareUtil.allJSONObjects(expected)) {
            this.compareJSONArrayOfJsonObjects(prefix, expected, actual, result);
        } else {
            this.recursivelyCompareJSONArray(prefix, expected, actual, result);
        }
    }
}

