/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wiremock.org.json.JSONArray;
import wiremock.org.json.JSONObject;
import wiremock.org.skyscreamer.jsonassert.FieldComparisonFailure;
import wiremock.org.skyscreamer.jsonassert.ValueMatcherException;

public class JSONCompareResult {
    private boolean _success;
    private StringBuilder _message;
    private String _field;
    private Object _expected;
    private Object _actual;
    private final List<FieldComparisonFailure> _fieldFailures = new ArrayList<FieldComparisonFailure>();

    public JSONCompareResult() {
        this(true, null);
    }

    private JSONCompareResult(boolean success, String message) {
        this._success = success;
        this._message = new StringBuilder(message == null ? "" : message);
    }

    public boolean passed() {
        return this._success;
    }

    public boolean failed() {
        return !this._success;
    }

    public String getMessage() {
        return this._message.toString();
    }

    public List<FieldComparisonFailure> getFieldFailures() {
        return Collections.unmodifiableList(this._fieldFailures);
    }

    public Object getActual() {
        return this._actual;
    }

    public Object getExpected() {
        return this._expected;
    }

    public boolean isFailureOnField() {
        return !this._fieldFailures.isEmpty();
    }

    public String getField() {
        return this._field;
    }

    public void fail(String message) {
        this._success = false;
        if (this._message.length() == 0) {
            this._message.append(message);
        } else {
            this._message.append(" ; ").append(message);
        }
    }

    public JSONCompareResult fail(String field, Object expected, Object actual) {
        this._fieldFailures.add(new FieldComparisonFailure(field, expected, actual));
        this._field = field;
        this._expected = expected;
        this._actual = actual;
        this.fail(this.formatFailureMessage(field, expected, actual));
        return this;
    }

    public JSONCompareResult fail(String field, ValueMatcherException exception) {
        this.fail(field + ": " + exception.getMessage(), exception.getExpected(), exception.getActual());
        return this;
    }

    private String formatFailureMessage(String field, Object expected, Object actual) {
        return field + "\nExpected: " + JSONCompareResult.describe(expected) + "\n     got: " + JSONCompareResult.describe(actual) + "\n";
    }

    public JSONCompareResult missing(String field, Object expected) {
        this.fail(this.formatMissing(field, expected));
        return this;
    }

    private String formatMissing(String field, Object expected) {
        return field + "\nExpected: " + JSONCompareResult.describe(expected) + "\n     but none found\n";
    }

    public JSONCompareResult unexpected(String field, Object value) {
        this.fail(this.formatUnexpected(field, value));
        return this;
    }

    private String formatUnexpected(String field, Object value) {
        return field + "\nUnexpected: " + JSONCompareResult.describe(value) + "\n";
    }

    private static String describe(Object value) {
        if (value instanceof JSONArray) {
            return "a JSON array";
        }
        if (value instanceof JSONObject) {
            return "a JSON object";
        }
        return value.toString();
    }

    public String toString() {
        return this._message.toString();
    }
}

