/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import wiremock.com.jayway.jsonpath.Filter;
import wiremock.com.jayway.jsonpath.InvalidPathException;
import wiremock.com.jayway.jsonpath.internal.IOUtils;
import wiremock.com.jayway.jsonpath.internal.PathToken;
import wiremock.com.jayway.jsonpath.internal.PathTokenizer;
import wiremock.com.jayway.jsonpath.internal.filter.PathTokenFilter;
import wiremock.com.jayway.jsonpath.spi.HttpProviderFactory;
import wiremock.com.jayway.jsonpath.spi.JsonProvider;
import wiremock.com.jayway.jsonpath.spi.JsonProviderFactory;
import wiremock.org.apache.commons.lang.StringUtils;
import wiremock.org.apache.commons.lang.Validate;

public class JsonPath {
    private static Pattern DEFINITE_PATH_PATTERN = Pattern.compile(".*(\\.\\.|\\*|\\[[\\\\/]|\\?|,|:\\s?\\]|\\[\\s?:|>|\\(|<|=|\\+).*");
    private PathTokenizer tokenizer;
    private LinkedList<Filter> filters;

    public JsonPath(String jsonPath, Filter[] filters) {
        if (jsonPath == null || jsonPath.trim().isEmpty() || jsonPath.matches("[^\\?\\+\\=\\-\\*\\/\\!]\\(")) {
            throw new InvalidPathException("Invalid path");
        }
        int filterCountInPath = StringUtils.countMatches(jsonPath, "[?]");
        Validate.isTrue(filterCountInPath == filters.length, "Filters in path ([?]) does not match provided filters.");
        this.tokenizer = new PathTokenizer(jsonPath);
        this.filters = new LinkedList();
        this.filters.addAll(Arrays.asList(filters));
    }

    PathTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public JsonPath copy() {
        return new JsonPath(this.tokenizer.getPath(), this.filters.toArray(new Filter[0]));
    }

    public String getPath() {
        return this.tokenizer.getPath();
    }

    public boolean isPathDefinite() {
        String preparedPath = this.getPath().replaceAll("\"[^\"\\\\\\n\r]*\"", "");
        return !DEFINITE_PATH_PATTERN.matcher(preparedPath).matches();
    }

    public <T> T read(Object jsonObject) {
        Validate.notNull(jsonObject, "json can not be null");
        if (!(jsonObject instanceof Map) && !(jsonObject instanceof List)) {
            throw new IllegalArgumentException("Invalid container object");
        }
        LinkedList<Filter> contextFilters = new LinkedList<Filter>(this.filters);
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        Object result = jsonObject;
        boolean inArrayContext = false;
        for (PathToken pathToken : this.tokenizer) {
            PathTokenFilter filter = pathToken.getFilter();
            result = filter.filter(result, jsonProvider, contextFilters, inArrayContext);
            if (inArrayContext) continue;
            inArrayContext = filter.isArrayFilter();
        }
        return (T)result;
    }

    public <T> T read(String json) {
        Validate.notEmpty(json, "json can not be null or empty");
        return this.read(JsonProviderFactory.createProvider().parse(json));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(URL jsonURL) throws IOException {
        Validate.notNull(jsonURL, "json URL can not be null");
        InputStream in = null;
        try {
            in = HttpProviderFactory.getProvider().get(jsonURL);
            T t = this.read(JsonProviderFactory.createProvider().parse(in));
            return t;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(File jsonFile) throws IOException {
        T t;
        Validate.notNull(jsonFile, "json file can not be null");
        Validate.isTrue(jsonFile.exists(), "json file does not exist");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jsonFile);
            t = this.read(JsonProviderFactory.createProvider().parse(fis));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(fis);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(InputStream jsonInputStream) throws IOException {
        Validate.notNull(jsonInputStream, "json input stream can not be null");
        try {
            T t = this.read(JsonProviderFactory.createProvider().parse(jsonInputStream));
            return t;
        }
        finally {
            IOUtils.closeQuietly(jsonInputStream);
        }
    }

    public static JsonPath compile(String jsonPath, Filter ... filters) {
        Validate.notEmpty(jsonPath, "json can not be null or empty");
        return new JsonPath(jsonPath, filters);
    }

    public static <T> T read(String json, String jsonPath, Filter ... filters) {
        Validate.notEmpty(json, "json can not be null or empty");
        Validate.notEmpty(jsonPath, "jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(json);
    }

    public static <T> T read(Object json, String jsonPath, Filter ... filters) {
        Validate.notNull(json, "json can not be null");
        Validate.notNull(jsonPath, "jsonPath can not be null");
        return JsonPath.compile(jsonPath, filters).read(json);
    }

    public static <T> T read(URL jsonURL, String jsonPath, Filter ... filters) throws IOException {
        Validate.notNull(jsonURL, "json URL can not be null");
        Validate.notEmpty(jsonPath, "jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(jsonURL);
    }

    public static <T> T read(File jsonFile, String jsonPath, Filter ... filters) throws IOException {
        Validate.notNull(jsonFile, "json file can not be null");
        Validate.notEmpty(jsonPath, "jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(jsonFile);
    }

    public static <T> T read(InputStream jsonInputStream, String jsonPath, Filter ... filters) throws IOException {
        Validate.notNull(jsonInputStream, "json input stream can not be null");
        Validate.notEmpty(jsonPath, "jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(jsonInputStream);
    }
}

