/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.DB;
import com.versionone.Duration;
import com.versionone.Oid;
import com.versionone.apiclient.AssetState;
import com.versionone.apiclient.AssetType;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.exceptions.OidException;
import com.versionone.apiclient.exceptions.V1Exception;
import com.versionone.apiclient.filters.IFilterTerm;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.apiclient.services.TextBuilder;
import java.util.UUID;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

class AttributeDefinition
implements IAttributeDefinition {
    private IMetaModel meta;
    private IAssetType _assettype;
    private String _assettypetoken;
    private String _name;
    private String _token;
    private IAttributeDefinition.AttributeType _attributetype;
    private IAttributeDefinition _base = null;
    private String _basetoken = null;
    private boolean _isreadonly;
    private boolean _isrequired;
    private boolean _ismultivalue;
    private IAssetType _relatedasset = null;
    private String _relatedassettoken = null;
    private String _displayname;

    public AttributeDefinition(IMetaModel meta, Element element) throws Exception {
        Element relatedelement;
        this.meta = meta;
        this._token = element.getAttribute("token");
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        TextBuilder.splitPrefix(this._token, '.', prefix, suffix);
        this._assettypetoken = prefix.toString();
        this._name = suffix.toString();
        this._displayname = element.getAttribute("displayname");
        this._attributetype = IAttributeDefinition.AttributeType.valueOf(element.getAttribute("attributetype"));
        this._isreadonly = new DB.Bit(element.getAttribute("isreadonly")).booleanValue();
        this._isrequired = new DB.Bit(element.getAttribute("isrequired")).booleanValue();
        this._ismultivalue = new DB.Bit(element.getAttribute("ismultivalue")).booleanValue();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element baseelement = (Element)xpath.evaluate("Base", element, XPathConstants.NODE);
        if (baseelement != null) {
            this._basetoken = baseelement.getAttribute("tokenref");
        }
        if ((relatedelement = (Element)xpath.evaluate("RelatedAsset", element, XPathConstants.NODE)) != null) {
            this._relatedassettoken = relatedelement.getAttribute("nameref");
        }
        ((AssetType)this.getAssetType()).saveAttributeDefinition(this);
    }

    @Override
    public Object coerce(Object value) throws V1Exception {
        switch (this.getAttributeType()) {
            case Boolean: {
                return new DB.Bit(value).getValue();
            }
            case Numeric: {
                return new DB.Real(value).getValue();
            }
            case Date: {
                return new DB.DateTime(value).getValue();
            }
            case Duration: {
                if (value == null || value instanceof Duration) {
                    return value;
                }
                if (value instanceof Integer) {
                    return new Duration((Integer)value, Duration.Unit.Days);
                }
                return Duration.parse((String)value);
            }
            case Text: 
            case LongText: 
            case LocalizerTag: 
            case Password: {
                return new DB.Str(value).getValue();
            }
            case Relation: {
                Oid oid = this.coerceOid(value);
                if (this.getRelatedAsset() != null && !oid.isNull() && !oid.getAssetType().isA(this.getRelatedAsset())) {
                    throw new OidException("Wrong OID AssetType", oid.getToken());
                }
                return oid;
            }
            case AssetType: {
                return this.coerceAssetType(value);
            }
            case Opaque: {
                return value;
            }
            case State: {
                return this.coerceState(value);
            }
            case Rank: {
                return value;
            }
            case LongInt: {
                return new DB.BigInt(value).getValue();
            }
            case Blob: {
                return value;
            }
            case Guid: {
                if (value == null || StringUtils.isEmpty(value.toString())) {
                    throw new NullArgumentException("value");
                }
                return UUID.fromString(new DB.Str(value).getValue());
            }
        }
        throw new MetaException("Unsupported AttributeType ", this.getAttributeType().toString());
    }

    private Object coerceState(Object value) {
        if (value instanceof AssetState) {
            return value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).ordinal();
        }
        if (value instanceof Byte) {
            int intValue = ((Byte)value).intValue();
            if (AssetState.isDefined(intValue)) {
                return AssetState.valueOf(intValue);
            }
            return intValue;
        }
        String stringval = "" + value;
        try {
            return AssetState.valueOf(stringval);
        }
        catch (Exception exception) {
            return Integer.parseInt(stringval);
        }
    }

    private Oid coerceOid(Object value) throws V1Exception {
        if (null == value) {
            return Oid.Null;
        }
        if (value instanceof Oid) {
            return (Oid)value;
        }
        if (value instanceof String) {
            return Oid.fromToken((String)value, this.meta);
        }
        if (value instanceof Integer) {
            return new Oid(this.getRelatedAsset(), new DB.Int((Integer)value), null);
        }
        throw new OidException("Object is not convertible to an OID", value.toString());
    }

    private IAssetType coerceAssetType(Object value) throws MetaException {
        if (value instanceof IAssetType) {
            return (IAssetType)value;
        }
        if (value instanceof String) {
            return this.meta.getAssetType((String)value);
        }
        throw new MetaException("Object is not convertible to an AssetType", value.toString());
    }

    @Override
    public IAssetType getAssetType() throws MetaException {
        if (this._assettype == null) {
            this._assettype = this.meta.getAssetType(this._assettypetoken);
        }
        return this._assettype;
    }

    @Override
    public IAttributeDefinition.AttributeType getAttributeType() {
        return this._attributetype;
    }

    @Override
    public IAttributeDefinition getBase() throws MetaException {
        if (this._base == null && this._basetoken != null) {
            this._base = this.meta.getAttributeDefinition(this._basetoken);
        }
        return this._base;
    }

    @Override
    public String getDisplayName() {
        return this._displayname;
    }

    @Override
    public boolean isMultiValue() {
        return this._ismultivalue;
    }

    @Override
    public boolean isReadOnly() {
        return this._isreadonly;
    }

    @Override
    public boolean isRequired() {
        return this._isrequired;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public IAssetType getRelatedAsset() throws MetaException {
        if (this._relatedasset == null && this._relatedassettoken != null) {
            this._relatedasset = this.meta.getAssetType(this._relatedassettoken);
        }
        return this._relatedasset;
    }

    @Override
    public String getToken() {
        return this._token;
    }

    @Override
    public IAttributeDefinition downcast(IAssetType assetType) {
        if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Relation)) {
            if (assetType.isA(this.getRelatedAsset())) {
                return this.meta.getAttributeDefinition(this.getToken() + ":" + assetType.getToken());
            }
            throw new MetaException("Cannot downcast to unrelated type");
        }
        throw new MetaException("Cannot downcast non-relation attributes");
    }

    @Override
    public IAttributeDefinition filter(IFilterTerm filter) throws APIException {
        if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Relation)) {
            return this.meta.getAttributeDefinition(this.getToken() + "[" + filter.getShortToken() + "]");
        }
        throw new MetaException("Cannot filter non-relation attributes");
    }

    @Override
    public IAttributeDefinition join(IAttributeDefinition joined) {
        if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Relation)) {
            if (this.getRelatedAsset().isA(joined.getAssetType())) {
                return this.meta.getAttributeDefinition(this.getToken() + "." + joined.getName());
            }
            throw new MetaException("Cannot join unrelated attributes");
        }
        throw new MetaException("Cannot join non-relation attributes");
    }

    @Override
    public IAttributeDefinition aggregate(IAttributeDefinition.Aggregate aggregate) {
        if (this.isMultiValue()) {
            if (aggregate.equals((Object)IAttributeDefinition.Aggregate.Min)) {
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Numeric)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@Min");
                }
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Date)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@MinDate");
                }
                throw new MetaException("Must aggregate MIN of numerics and dates");
            }
            if (aggregate.equals((Object)IAttributeDefinition.Aggregate.Max)) {
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Numeric)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@Max");
                }
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Date)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@MaxDate");
                }
                throw new MetaException("Must aggregate MAX of numerics and dates");
            }
            if (aggregate.equals((Object)IAttributeDefinition.Aggregate.Count)) {
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Relation)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@Count");
                }
                throw new MetaException("Must aggregate COUNT of relations");
            }
            if (aggregate.equals((Object)IAttributeDefinition.Aggregate.Sum)) {
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Numeric)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@Sum");
                }
                throw new MetaException("Must aggregate SUM of numerics");
            }
            if (aggregate.equals((Object)IAttributeDefinition.Aggregate.And)) {
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Boolean)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@and");
                }
                throw new MetaException("Must aggregate AND of booleans");
            }
            if (aggregate.equals((Object)IAttributeDefinition.Aggregate.Or)) {
                if (this.getAttributeType().equals((Object)IAttributeDefinition.AttributeType.Boolean)) {
                    return this.meta.getAttributeDefinition(this.getToken() + ".@or");
                }
                throw new MetaException("Must aggregate OR of booleans");
            }
        }
        throw new MetaException("Must aggregate multi-value attributes");
    }
}

