/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.AdminTasks;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final Admin admin;

    public AdminRequestHandler(Admin admin, ResponseRenderer responseRenderer) {
        super(responseRenderer);
        this.admin = admin;
    }

    @Override
    public ResponseDefinition handleRequest(Request request) {
        LocalNotifier.notifier().info("Received request to " + request.getUrl() + " with body " + request.getBodyAsString());
        AdminTask adminTask = AdminTasks.taskFor(request.getMethod(), AdminRequestHandler.withoutAdminRoot(request.getUrl()));
        return adminTask.execute(this.admin, request);
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

