/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import wiremock.com.google.common.io.ByteStreams;

public class BinaryFile {
    private URI uri;

    public BinaryFile(URI uri) {
        this.uri = uri;
    }

    public byte[] readContents() {
        InputStream stream = null;
        try {
            stream = this.uri.toURL().openStream();
            byte[] byArray = ByteStreams.toByteArray(stream);
            return byArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.closeStream(stream);
        }
    }

    private void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public String name() {
        return this.uri.toString();
    }

    public String toString() {
        return this.name();
    }
}

