#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys, traceback, itertools
from versionone.VersionOneClient import VersionOneClient

# convert int to string and list to comma separated values to avoid unicode characters
def getAttributeValues(attributeValues):
   value = str(attributeValues) if type(attributeValues) is int else attributeValues
   return ",".join(value) if type(value) is list else value

try:
   v1Client = VersionOneClient.create_v1Client( versionOneServer )
   results = v1Client.getPortfolioItems( whereClause )
   assets = results['Assets']
   assetFields = ['Timebox','Description','AssetState','ToDo','DetailEstimate','Reference','Scope','Parent','SecurityScope','Order','Source','Swag','Value','MorphedFrom','Category','PlannedEnd','PlannedStart','TimeCriticality','RiskReduction','ComplexityRank','Ideas','TaggedWith','Status','Owners','Priority','Team',
                  'Risk','RequestedBy']
   assetValues = ['Timebox.Name','Description','AssetState','ToDo','DetailEstimate','Reference','Scope.Name','Parent.Name','SecurityScope.Name','Order','Source.Name','Swag','Value','MorphedFrom.Name','Category.Name','PlannedEnd','PlannedStart','TimeCriticality','RiskReduction','ComplexityRank','Ideas','TaggedWith','Status.Name','Owners.Name','Priority.Name','Team.Name',
                  'Risk','RequestedBy']

   data = {}
   for asset in assets:
      assetNumber = asset['Attributes']['Number']['value']
      data[assetNumber] = {'Asset Name : %s' % getAttributeValues(asset['Attributes']['Name']['value']) }
      print("Portfolio : %s" % assetNumber )
      print("==========")
      for assetField,assetValue in itertools.izip_longest(assetFields,assetValues):
        if asset['Attributes'][assetValue]['value']:
            attributeValue = getAttributeValues(asset['Attributes'][assetValue]['value'])
            data[assetNumber].update({"%s : %s" % (assetField,attributeValue)})
            print("%s : %s" % (assetField,attributeValue))
      if asset['Attributes']['Super']['value'] :
         data[assetNumber].update({"Portfolio : %s" % getAttributeValues(asset['Attributes']['Super']['value']['idref'])})
         print("Portfolio : %s" % asset['Attributes']['Super']['value']['idref'])
   # End for

except :
   traceback.print_exc(file=sys.stdout)
   sys.exit(1)
   # End try
