/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.DB;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.V1Exception;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import java.util.ArrayList;

class MultiValueAttribute
extends Attribute {
    private ArrayList _values = new ArrayList();
    private ArrayList _addedvalues = new ArrayList();
    private ArrayList _removedvalues = new ArrayList();
    private ArrayList _newvalues;

    MultiValueAttribute(IAttributeDefinition def, Asset asset) {
        super(def, asset);
    }

    @Override
    public Object getOriginalValue() throws APIException {
        if (this._values == null) {
            return null;
        }
        if (this._values.size() == 0) {
            try {
                return this.getDefinition().coerce(DB.Null);
            }
            catch (V1Exception e) {
                throw new APIException("Error converting data", e);
            }
        }
        if (this._values.size() == 1) {
            return this._values.get(0);
        }
        throw new RuntimeException("Attribute contains multiple values: " + this.getDefinition().getToken());
    }

    @Override
    public Object getNewValue() throws APIException {
        if (this._newvalues == null) {
            return null;
        }
        if (this._newvalues.size() == 0) {
            try {
                return this.getDefinition().coerce(DB.Null);
            }
            catch (V1Exception e) {
                throw new APIException("Error converting data", e);
            }
        }
        if (this._newvalues.size() == 1) {
            return this._newvalues.get(0);
        }
        throw new RuntimeException("Attribute contains multiple values: " + this.getDefinition().getToken());
    }

    @Override
    public Object[] getOriginalValues() {
        return this._values == null ? null : this._values.toArray();
    }

    @Override
    public Object[] getNewValues() {
        return this._newvalues == null ? null : this._newvalues.toArray();
    }

    @Override
    public Object[] getAddedValues() {
        return this._addedvalues == null ? null : this._addedvalues.toArray();
    }

    @Override
    public Object[] getRemovedValues() {
        return this._removedvalues == null ? null : this._removedvalues.toArray();
    }

    @Override
    public boolean hasChanged() {
        return this._newvalues != null && this._newvalues.size() > 0 || this._removedvalues != null && this._removedvalues.size() > 0;
    }

    @Override
    void setValue(Object value) {
        throw new RuntimeException("Cannot set value on a multi-value attribute: " + this.getDefinition().getToken());
    }

    @Override
    void forceValue(Object value) {
        throw new RuntimeException("Cannot force value on a multi-value attribute: " + this.getDefinition().getToken());
    }

    @Override
    void addValue(Object value) throws APIException {
        this.checkReadOnly();
        try {
            value = this.getDefinition().coerce(value);
        }
        catch (V1Exception e) {
            throw new APIException("Error converting data", e);
        }
        this.checkNull(value);
        if (this._newvalues == null) {
            this._newvalues = this._values != null ? new ArrayList(this._values) : new ArrayList();
        }
        this._newvalues.add(value);
        if (this._addedvalues == null) {
            this._addedvalues = new ArrayList();
        }
        this._addedvalues.add(value);
    }

    @Override
    void removeValue(Object value) throws APIException {
        this.checkReadOnly();
        try {
            value = this.getDefinition().coerce(value);
        }
        catch (V1Exception e) {
            throw new APIException("Error Converting Data", e);
        }
        if (this._newvalues == null) {
            this._newvalues = this._values != null ? new ArrayList(this._values) : new ArrayList();
        }
        this._newvalues.remove(value);
        if (this._removedvalues == null) {
            this._removedvalues = new ArrayList();
        }
        this._removedvalues.add(value);
    }

    @Override
    public void acceptChanges() {
        if (this.hasChanged()) {
            this._values = this._newvalues;
            this._removedvalues = null;
            this._addedvalues = null;
            this._newvalues = null;
        }
    }

    @Override
    public void rejectChanges() {
        this._removedvalues = null;
        this._addedvalues = null;
        this._newvalues = null;
    }

    @Override
    void loadValue(Object value) throws APIException {
        try {
            this._values.add(this.getDefinition().coerce(value));
        }
        catch (V1Exception e) {
            throw new APIException("Error converting data", e);
        }
    }
}

