#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import com.xhaus.jyson.JysonCodec as json
from xlrelease.HttpRequest import HttpRequest
from base64 import b64encode

STATUS_OK = 200


class VersionOneClient(object):

    def __init__(self, v1CI):
        self.uriBase = v1CI['url']
        self.Token = v1CI['accessToken']
        self.username = v1CI['username']
        self.password = v1CI['password']
        self.proxyHost = v1CI['proxyHost']
        self.proxyPort = v1CI['proxyPort']
        self.proxyUsername = v1CI['proxyUsername']
        self.proxyPassword = v1CI['proxyPassword']
        self.proxyDomain = v1CI['proxyDomain']
        self.listAttributeNames = {"Priority": "Priority",  "Status": "Status", "Category": "Category", "Source": "Source"}
        # Connection using Token
        if self.Token:
            self.optionHeader = {"Accept": "application/json", "Authorization": "Bearer %s" % self.Token}

        # Connection using username/password
        elif self.password:
            self.auth = b64encode('%s:%s' % (self.username, self.password))
            self.optionHeader = {"Accept": "application/json", "Authorization": "Basic %s" % self.auth}

        self.httpConnection = v1CI
        self.httpRequest = HttpRequest(v1CI)

    # End def

    @staticmethod
    def create_v1Client(v1CI):
        return VersionOneClient(v1CI)

    # End def

    def checkConnection(self):
        uri = "/rest-1.oauth.v1/query.v1"
        data = "\nfrom: Member\nselect:\n  - Name\nwhere:\n  IsSelf: true\n"
        response = self.httpRequest.post(uri, data, headers=self.optionHeader)
        reqStatus = response.getStatus()
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        else:
            raise ValueError("Error while testing the connection", reqStatus)
        # End if

    # End def

    def getAssetByName(self, assetType, assetName):
        uri = "/rest-1.oauth.v1/Data/%s?find='%s'&findin=Name" % (assetType, assetName)

        # End if
        print("getAssetByName uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def

    def getPlanningLevel(self, oid):
        uri = "/rest-1.oauth.v1/Data/%s" % (oid)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting Planning level', reqStatus)
    # End def

    def getStories(self, whereClause=None):
        uri = "/rest-1.oauth.v1/Data/Story"
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        # End if
        print("getStories uri = %s" % uri)
        #print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

    # End def

    def getPortfolioItems(self, whereClause=None):
        uri = "/rest-1.oauth.v1/Data/Epic"
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        # End if
        print("getPortfolioItems uri = %s" % uri)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting portfolio items', reqStatus)

    # End def


    def getAssetTemplate(self, assetType=None, whereClause=None):
        uri = "/rest-1.oauth.v1/Data/%s" % (assetType)
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        resStatus = response.getStatus()
        if resStatus == STATUS_OK:
            results = json.loads(response.getResponse())
            if results['total'] != 0:
                asset = results['Assets'][0]
                assetState = asset['Attributes']['AssetState']['value']
                assetType = asset['Attributes']['AssetType']['value']
                if (assetState == 200 and assetType == "Story") or (assetState == 200 and assetType == "Defect"):
                    return results
            print("No asset template found with the provided assetTemplateId.")
            sys.exit(1)
        else:
            print('Error while getting asset template: %s', resStatus)
            sys.exit(1)

    # End def

    def getAssets(self, assetType=None, whereClause=None):
        uri = "/rest-1.oauth.v1/Data/%s" % (assetType)
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        # End if
        print("getAssets uri = %s" % uri)
        #print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting asset', reqStatus)

    # End def

    def getMember(self, whereClause=None, id=None):
        uri = "/rest-1.oauth.v1/Data/Member"
        if whereClause is not None:
            uri = "%s?where=%s" % (uri, whereClause)
        if id is not None:
            uri = "%s/%s" % (uri, id)
        # End if
        print("getMember uri = %s" % uri)
        print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting member details', reqStatus)

    # End def

    def updateAssetStatus(self, ticket, status, assetType ):
        whereClause = "Number='%s'" % ticket
        if(assetType == "Story") : data = self.getStories(whereClause)
        else : data = self.getAssets(assetType,whereClause)
        if len(data['Assets']) > 0 :
            uri = data['Assets'][0]['href']
            uri = uri.replace("/Agility/", "/")
            uri = uri.replace("/VersionOne/", "/")
        else:  raise ValueError('Unable to get Assets, Type of asset is %s but Ticket is %s' %(assetType,ticket))
        print("story status %s" % status)
        #xml = "<Asset> <Relation name=\"Status\" act=\"set\"> <Asset idref=\"StoryStatus:%s\" /> </Relation> </Asset>" % self.create_story_status()[status]
        if(assetType == "Defect" or assetType == "Story"):
            xml = "<Asset> <Relation name=\"Status\" act=\"set\"> <Asset idref=\"StoryStatus:%s\" /> </Relation> </Asset>" % self.get_status_list_by_teamprocess(ticket,assetType)[status]
        else:
            xml = "<Asset> <Relation name=\"Status\" act=\"set\"> <Asset idref=\"%sStatus:%s\" /> </Relation> </Asset>" % (assetType, self.get_status_list_by_teamprocess(ticket,assetType)[status])
        print("Update Status uri = %s" % uri)
        print("Update Status XML ~%s~" % xml)
        #Update Status XML ~<Asset> <Relation name="Status" act="set"> <Asset idref="StoryStatus:137" /> </Relation> </Asset>~
        #print("Update Status Headers = %s" % self.optionHeader)
        response = self.httpRequest.post(uri, xml, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return
        # End if
        raise ValueError('Error getting Assets', reqStatus)

    # End def

    def get_story_status_list(self):
        uri = "/rest-1.oauth.v1/Data/StoryStatus?sel=Name,RollupState,Team.Name&where=Team.Name=\"\""
        print("getStoryStatus uri = %s" % uri)
        #print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)

        results = json.loads(response.getResponse())
        data = {}
        assets = results['Assets']
        for asset in assets:
            key = asset['Attributes']['Name']['value']
            value = asset['id'].split(":")[1]
            data[key] = value

        print("data=%s" % data)

        req_status = response.getStatus()
        print("Request Status %s" % req_status)
        if req_status == STATUS_OK:
            #return json.loads(response.getResponse())
            return data
        # End if
        raise ValueError('Error getting Asset statuses', req_status)
    # End def

    def get_status_list_by_team(self, assetType, teamName=None):
        if(teamName is not None and teamName and teamName.strip()):
            if(assetType == "Defect" or assetType == "Story"):
                uri = "/rest-1.oauth.v1/Data/StoryStatus?sel=Name,RollupState,Team.Name&where=Team.Name=\"%s\"" % (teamName)
            else:
                uri = "/rest-1.oauth.v1/Data/%sStatus?sel=Name,Team.Name&where=Team.Name=\"%s\"" % (assetType, teamName)
        else:
            if(assetType == "Defect" or assetType == "Story"):
                uri = "/rest-1.oauth.v1/Data/StoryStatus?sel=Name,RollupState,Team.Name&where=Team.Name=\"\""
            else:
                uri = "/rest-1.oauth.v1/Data/%sStatus?sel=Name,Team.Name&where=Team.Name=\"\"" % (assetType)
        print("getStatus uri = %s" % uri)
        #print("Headers = %s" % self.optionHeader)
        response = self.httpRequest.get(uri, headers=self.optionHeader)

        results = json.loads(response.getResponse())
        data = {}
        assets = results['Assets']
        for asset in assets:
            key = asset['Attributes']['Name']['value']
            value = asset['id'].split(":")[1]
            data[key] = value

        print("data=%s" % data)

        req_status = response.getStatus()
        print("Request Status %s" % req_status)
        if req_status == STATUS_OK:
            #return json.loads(response.getResponse())
            return data
        # End if
        raise ValueError('Error getting story status', req_status)
    # End def

    def get_status_list_by_teamprocess(self, ticket, assetType):
        if(assetType == "Story") : results = self.getStories("Number='%s'" % ticket)
        else : results = self.getAssets(assetType,"Number='%s'" % ticket)
        asset = results['Assets'][0]
        teamName = asset['Attributes']['Team.Name']['value']
        print("team name=%s" % teamName)
        statuses = self.get_status_list_by_team(assetType, teamName)
        if teamName and teamName.strip() and len(statuses)>0:
            print("%s %s under team '%s' has team process set with %s statuses."% (assetType, ticket, teamName, len(statuses)))
            return self.get_status_list_by_team(assetType, teamName)
        else:
            print("%s %s under team '%s' has no team process set."% (assetType, ticket, teamName))
            return self.get_status_list_by_team(assetType)

    # End def

    def get_list_item_type(self, key):
        try:
            return self.listAttributeNames[key]
        except Exception:
            return None

    def findStoryById(self, storyId, attributes):
        uri = "/rest-1.oauth.v1/Data/Story/%s?sel=%s" % (storyId,attributes)
        print ("uri : %s" % uri)
        response = self.httpRequest.get(uri, headers=self.optionHeader)
        reqStatus = response.getStatus()
        print("Request Status %s" % reqStatus)
        if reqStatus == STATUS_OK:
            return json.loads(response.getResponse())
        # End if
        raise ValueError('Error getting stories', reqStatus)

# End class