#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys, traceback, itertools
from versionone.VersionOneClient import VersionOneClient

try:
   v1Client = VersionOneClient.create_v1Client( versionOneServer )
   results = v1Client.getStories( whereClause )
   assets = results['Assets']
   assetFields = ['Status','Owners','Priority','Team',
                  'Risk','RequestedBy','Estimate','Description']
   assetValues = ['Status.Name','Owners.Name','Priority.Name','Team.Name',
                  'Risk.Name','RequestedBy','Estimate','Description']

   data = {}
   for asset in assets:
      assetNumber = asset['Attributes']['Number']['value']
      data[assetNumber] = {'Asset Name : %s' % asset['Attributes']['Name']['value'] }
      print("Story : %s" % assetNumber )
      print("==========")
      for assetField,assetValue in itertools.izip_longest(assetFields,assetValues):
         if asset['Attributes'][assetValue]['value'] is not None:
            data[assetNumber].update({"%s : %s" % (assetField, asset['Attributes'][assetValue]['value'])})
            print("%s : %s" % (assetField,asset['Attributes'][assetValue]['value']))
      if asset['Attributes']['Super']['value'] is not None:
         data[assetNumber].update({"Portfolio : %s" % (asset['Attributes']['Super']['value']['idref'])})
         print("Portfolio : %s" % asset['Attributes']['Super']['value']['idref'])
   # End for

except :
   traceback.print_exc(file=sys.stdout)
   sys.exit(1)
   # End try