#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys, traceback
from versionone.VersionOneClient import VersionOneClient

try:
    data = {}
    v1Client = VersionOneClient.create_v1Client(versionOneServer)
    whereClause = "Number='%s'" % ticket
    results = v1Client.getAssets(assetType, whereClause)
    asset = results['Assets'][0]

#   Common details among all assets
    fetchKeyFromAssets = {"Name" : "Name", "Sprint/Iteration" : "Timebox.Name", "Number" : "Number",
     "Backlog Group/Backlog" : "Parent.Name", "Portfolio Item" : "Super.Name", "Project" : "Scope.Name",
     "Status" : "Status.Name", "Team" : "Team.Name", "Owners" : "Owners.Name",
     "Tags" : "TaggedWith", "To Do Hrs." : "ToDo", "Description" : "Description",
     "Reference" : "Reference", "Detail Estimate Hrs." : "DetailEstimate"}

    fetchKeyBasedOnAssetType = {}

#   Details for single Task asset
    if(assetType == "Task"):
        fetchKeyBasedOnAssetType = {"Source" : "Source.Name", "Build" : "LastVersion", "Type" : "Category.Name"}

#   Details for single Test asset
    if(assetType == "Test"):
        fetchKeyBasedOnAssetType = {"Done Hrs." : "Estimate", "Generated From" : "GeneratedFrom.Name", "Setup" : "Setup", "Inputs" : "Inputs",
        "Steps" : "Steps", "Expected Results" : "ExpectedResults", "Actual Results" : "ActualResults", "Type" : "Category.Name"}

#   Common details among Story/Defect asset
    if((assetType == "Story") or (assetType == "Defect")):
        fetchKeyBasedOnAssetType = {"Estimate Pts." : "Estimate", "Delivery Category" : "DeliveryCategory", "Priority" : "Priority.Name",
        "Class of Service" : "ClassOfService.Name", "Code Complexity Rank" : "ComplexityRank",
         "Split From ID" : "SplitFrom.Number", "Split From" : "SplitFrom.Name"}
        fetchKeyFromAssets.update(fetchKeyBasedOnAssetType)

#       Details for single Story asset
        if(assetType == "Story"):
            fetchKeyBasedOnAssetType = {"Risk" : "Risk.Name", "Customer" : "Customer.Name", "Requested By" : "RequestedBy",
            "Source" : "Source.Name", "Build" : "LastVersion", "Planned Estimate Pts." : "OriginalEstimate",
            "Retrospective" : "IdentifiedIn.Name", "Type" : "Category.Name"}

#       Details for single Defect asset
        if(assetType == "Defect"):
            fetchKeyBasedOnAssetType = {"Source" : "Source.Name", "Resolved in Build" : "FixedInBuild", "Resolution" : "ResolutionReason.Name",
            "Environment" : "Environment", "Resolution Details" : "Resolution", "Version Affected" : "VersionAffected",
            "Found in Build" : "FoundInBuild", "Found By" : "FoundBy", "Verified By" : "VerifiedBy.Name", "Type" : "Type.Name"}

#   Append more keys to main dictionary based on asset type
    fetchKeyFromAssets.update(fetchKeyBasedOnAssetType)

#   Loop to store suitable key-value pair to display
    for key in fetchKeyFromAssets:
        data[key] = asset['Attributes'][fetchKeyFromAssets[key]]['value']

#   Fetching planning-level attribute from project level
    project_oid = asset['Attributes']['SecurityScope']['value']['idref'].replace(":", "\\")
    asset = v1Client.getPlanningLevel(project_oid)
    data['Planning Level'] = asset['Attributes']['PlanningLevel.Name']['value']
    print( data )
except :
    traceback.print_exc(file=sys.stdout)
    sys.exit(1)
    # End try
