/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.V1Connector;
import com.versionone.apiclient.XMLHandler;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.interfaces.IAPIConnector;
import com.versionone.apiclient.interfaces.IV1Configuration;
import java.io.Reader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.NullArgumentException;
import org.w3c.dom.Document;

public class V1Configuration
implements IV1Configuration {
    private final String EffortTrackingKey = "EffortTracking";
    private final String StoryTrackingLevelKey = "StoryTrackingLevel";
    private final String DefectTrackingLevelKey = "DefectTrackingLevel";
    private final String MaxAttachmentSizeKey = "MaximumAttachmentSize";
    private final String CapacityPlanningKey = "CapacityPlanning";
    private IAPIConnector _connector;
    private Document _doc;
    private V1Connector _v1connector;

    public V1Configuration(IAPIConnector connector) {
        if (connector == null) {
            throw new NullArgumentException("connector");
        }
        this._connector = connector;
    }

    public V1Configuration(V1Connector connector) {
        if (connector == null) {
            throw new NullArgumentException("_v1connector");
        }
        this._v1connector = connector;
    }

    @Override
    public boolean isEffortTracking() throws ConnectionException, APIException {
        String value = this.getSetting("EffortTracking");
        return Boolean.parseBoolean(value);
    }

    @Override
    public IV1Configuration.TrackingLevel getStoryTrackingLevel() throws ConnectionException, APIException {
        String value = this.getSetting("StoryTrackingLevel");
        if (value != null && value.length() > 0) {
            return IV1Configuration.TrackingLevel.valueOf(value);
        }
        return IV1Configuration.TrackingLevel.On;
    }

    @Override
    public IV1Configuration.TrackingLevel getDefectTrackingLevel() throws ConnectionException, APIException {
        String value = this.getSetting("DefectTrackingLevel");
        if (value != null && value.length() > 0) {
            return IV1Configuration.TrackingLevel.valueOf(value);
        }
        return IV1Configuration.TrackingLevel.On;
    }

    @Override
    public int getMaxAttachmentSize() throws ConnectionException, APIException {
        String value = this.getSetting("MaximumAttachmentSize");
        if (value != null && value.length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    public String getCapacityPlanning() throws ConnectionException, APIException {
        String value = this.getSetting("CapacityPlanning");
        if (value != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    private String getSetting(String keyToFind) throws ConnectionException, APIException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("//Configuration/Setting[@key=\"" + keyToFind + "\"]/@value");
            return (String)expr.evaluate(this.get_doc(), XPathConstants.STRING);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private Document get_doc() throws ConnectionException, APIException {
        if (this._doc == null) {
            Reader reader;
            if (this._connector != null) {
                reader = this._connector.getData();
            } else {
                this._v1connector.useConfigAPI();
                reader = this._v1connector.getData();
            }
            this._doc = XMLHandler.buildDocument(reader, "");
        }
        return this._doc;
    }
}

