/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.jira.xlr.client;

import com.atlassian.jira.issue.customfields.option.Option;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.xebialabs.jira.xlr.client.ObjectMapperProvider;
import com.xebialabs.jira.xlr.client.TemplateNotFoundException;
import com.xebialabs.jira.xlr.client.XLReleaseClientException;
import com.xebialabs.jira.xlr.dto.CreateReleaseView;
import com.xebialabs.jira.xlr.dto.Release;
import com.xebialabs.jira.xlr.dto.ScriptUsername;
import com.xebialabs.jira.xlr.dto.TemplateVariable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLReleaseClient {
    private String user;
    private String password;
    private String serverUrl;
    private static final Logger log = LoggerFactory.getLogger(XLReleaseClient.class);

    public XLReleaseClient(String serverUrl, String username, String password) {
        this.user = username;
        this.password = password;
        this.serverUrl = serverUrl;
    }

    public String findFullFolderPathById(String folderId) throws TemplateNotFoundException {
        log.info(String.format("[XLR] findFullFolderPathById '%s'", folderId));
        String folderName = this.findFolderById(folderId);
        while (folderId.split("/").length > 2) {
            folderId = folderId.substring(0, folderId.lastIndexOf("/"));
            folderName = this.findFullFolderPathById(folderId) + "/" + folderName;
        }
        return folderName;
    }

    public String findFolderById(String folderId) throws TemplateNotFoundException {
        log.info(String.format("[XLR] findFolderById '%s'", folderId));
        String folderName = null;
        try {
            WebResource webResource = this.newWebResource().path("api/v1/folders/" + folderId);
            ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
            if (response.getStatus() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
            }
            String output = (String)response.getEntity(String.class);
            JSONObject jsonOutput = new JSONObject(output);
            if (jsonOutput.has("error")) {
                throw new RuntimeException("Failed : " + jsonOutput.getString("error_message"));
            }
            if (jsonOutput.getString("title") == null) {
                throw new RuntimeException("Failed to find folder name by id: " + folderId);
            }
            folderName = jsonOutput.getString("title");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folderName;
    }

    public String findFolderIdByName(String folderPath) throws TemplateNotFoundException {
        log.info(String.format("[XLR] findFolderById '%s'", folderPath));
        String folderId = null;
        try {
            WebResource webResource = this.newWebResource().path("api/v1/folders/find").queryParam("byPath", folderPath);
            ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
            if (response.getStatus() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
            }
            String output = (String)response.getEntity(String.class);
            JSONObject jsonOutput = new JSONObject(output);
            if (jsonOutput.has("error")) {
                throw new RuntimeException("Failed : " + jsonOutput.getString("error_message"));
            }
            if (jsonOutput.getString("id") == null) {
                throw new RuntimeException("Failed to find folder id by folder path: " + folderPath);
            }
            folderId = jsonOutput.getString("id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folderId;
    }

    public Release findTemplateByFolderAndTitle(String folderName, String templateTitle) throws TemplateNotFoundException {
        Release template;
        block7: {
            log.info(String.format("[XLR] findTemplateByFolderAndTitle '%s', '%s'", folderName, templateTitle));
            String folderId = null;
            template = null;
            try {
                if (!StringUtils.isNotBlank((String)folderName)) {
                    return this.findTemplateByTitle(templateTitle);
                }
                if (this.findFolderIdByName(folderName) != null) {
                    folderId = this.findFolderIdByName(folderName);
                    log.info(String.format("[XLR] findFolderId '%s'", folderId));
                    String searchPath = "api/v1/folders/" + folderId + "/templates";
                    WebResource webResource = this.newWebResource().path(searchPath);
                    ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
                    if (response.getStatus() != 200) {
                        throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
                    }
                    GenericType<List<Release>> genericType = new GenericType<List<Release>>(){};
                    List templateCandidates = (List)webResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)genericType);
                    for (Release templateCandidate : templateCandidates) {
                        if (!"TEMPLATE".equals(templateCandidate.getStatus()) || !templateTitle.equalsIgnoreCase(templateCandidate.getTitle())) continue;
                        template = templateCandidate;
                        log.info("found template name '%s' (template id = '%s')", (Object)template.getTitle(), (Object)template.getPublicId());
                    }
                    break block7;
                }
                throw new RuntimeException("Failed to find folder id by path: " + folderName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (template == null) {
            log.error(String.format("[XLR] findTemplateByFolderAndTitle: folder name = '%s', template name = '%s' not found", folderName, templateTitle));
            throw new TemplateNotFoundException("Template with title '" + templateTitle + "' not found in folder '" + folderName + "'");
        }
        return template;
    }

    public Release findTemplateByTitle(String templateTitle) throws TemplateNotFoundException {
        log.info(String.format("[XLR] findTemplateByTitle '%s'", templateTitle));
        WebResource service = this.newWebResource().path("api").path("v1").path("releases").path("byTitle").queryParam("releaseTitle", templateTitle);
        GenericType<List<Release>> genericType = new GenericType<List<Release>>(){};
        List templateCandidates = (List)service.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)genericType);
        StringBuilder strBuilder = new StringBuilder();
        for (Release templateCandidate : templateCandidates) {
            String templateId = templateCandidate.getId();
            if (templateId == null || templateId.lastIndexOf("/") <= 1) continue;
            System.out.println("************* templateId:" + templateId);
            String folderName = this.findFullFolderPathById(templateId.substring(0, templateId.lastIndexOf("/")));
            strBuilder.append(folderName + "/" + templateCandidate.getTitle());
            strBuilder.append(System.getProperty("line.separator"));
        }
        Release template = null;
        for (Release templateCandidate : templateCandidates) {
            if (!"TEMPLATE".equals(templateCandidate.getStatus())) continue;
            if (template != null) {
                log.error(String.format("[XLR] findTemplateByTitle '%s' not unique", templateTitle));
                throw new TemplateNotFoundException("Found more than 1 template that matches title '" + templateTitle + "'\n" + strBuilder.toString());
            }
            template = templateCandidate;
        }
        if (template == null) {
            log.error(String.format("[XLR] findTemplateByTitle '%s' not found", templateTitle));
            throw new TemplateNotFoundException("Template with title '" + templateTitle + "' not found");
        }
        return template;
    }

    public List<TemplateVariable> getVariables(String templateId) throws XLReleaseClientException {
        log.info(String.format("[XLR] getVariables '%s'", templateId));
        WebResource service = this.newWebResource().path("api").path("v1").path("releases").path(templateId).path("variables");
        GenericType<List<TemplateVariable>> genericType = new GenericType<List<TemplateVariable>>(){};
        try {
            return (List)service.accept(new String[]{"application/json"}).get((GenericType)genericType);
        }
        catch (Exception ex) {
            log.error(String.format("[XLR] getVariables failed '%s'", ex.getMessage()));
            throw new XLReleaseClientException("Unable to retrieve template variables", ex);
        }
    }

    public Release createRelease(String templateId, String releaseTitle, List<TemplateVariable> variables, List<String> tags, ScriptUsername scriptUsername, String scriptUserPassword) throws XLReleaseClientException {
        WebResource service = this.newWebResource();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String scheduledStartDate = format.format(Calendar.getInstance().getTime());
        Calendar dueDate = Calendar.getInstance();
        dueDate.add(5, 1);
        String scheduledDueDate = format.format(dueDate.getTime());
        CreateReleaseView createReleaseView = new CreateReleaseView(templateId, releaseTitle, variables, tags, scheduledDueDate, scheduledStartDate, scriptUsername, scriptUserPassword);
        log.info("[XLR] createRelease request");
        Map<String, Object> varsMap = this.convertVarialbes(createReleaseView);
        createReleaseView.setVariables(varsMap);
        ClientResponse response = (ClientResponse)((WebResource.Builder)service.path("api").path("v1").path("templates").path(templateId).path("create").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)createReleaseView);
        log.info(String.format("[XLR] createRelease response : '%s' status [%d]", response.getClientResponseStatus().name(), response.getStatus()));
        if (response.getClientResponseStatus().getFamily() != Response.Status.Family.SUCCESSFUL) {
            String errorReason = (String)response.getEntity(String.class);
            log.error(String.format("[XLR] createRelease ERROR: %s", errorReason));
            throw new XLReleaseClientException(errorReason);
        }
        GenericType<Release> genericType = new GenericType<Release>(){};
        Release release = (Release)response.getEntity((GenericType)genericType);
        log.debug(String.format("[XLR] createRelease result '%s'", release.toString()));
        return release;
    }

    public void startRelease(String releaseId) throws XLReleaseClientException {
        WebResource service = this.newWebResource().path("api").path("v1").path("releases").path(releaseId).path("start");
        log.info("[XLR] startRelease request");
        ClientResponse response = (ClientResponse)service.type("application/json").post(ClientResponse.class);
        log.info(String.format("[XLR] startRelease response : '%s' status [%d]", response.getClientResponseStatus().name(), response.getStatus()));
        if (response.getClientResponseStatus().getFamily() != Response.Status.Family.SUCCESSFUL) {
            String errorReason = (String)response.getEntity(String.class);
            log.error(String.format("[XLR] startRelease ERROR: %s", errorReason));
            throw new XLReleaseClientException(errorReason);
        }
    }

    private Map<String, Object> convertVarialbes(CreateReleaseView createReleaseView) {
        HashMap<String, Object> varsMap = new HashMap<String, Object>();
        for (TemplateVariable var : createReleaseView.getTemplateVariables()) {
            ArrayList<Object> arrs;
            String[] pair;
            HashMap<String, String> mapStrings;
            Object[] vals;
            String val;
            if ("xlrelease.DateVariable".equals(var.getType())) {
                if (var.getValue() instanceof Timestamp) {
                    Timestamp ts = (Timestamp)var.getValue();
                    ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneId.systemDefault());
                    String tsiso = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    log.info(String.format("[XLR] writing date variable '%s' as '%s'", var.getKey(), tsiso));
                    varsMap.put(var.getKey().toString(), tsiso);
                    continue;
                }
                log.info(String.format("[XLR] writing date variable '%s' as is", var.getKey()));
                continue;
            }
            if ("xlrelease.MapStringStringVariable".equals(var.getType())) {
                log.info("processing variable as MapStringStringVariable");
                log.info(String.format("var.getKey()= '%s', val.getValue()= '%s'", var.getKey().toString(), var.getValue() != null ? var.getValue().toString() : ""));
                val = var.getValue() != null ? var.getValue().toString() : "";
                String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                vals = val.split(delim);
                log.info(String.format("map variable='%s'", vals));
                mapStrings = new HashMap<String, String>();
                if (!"{}".equals(val) && vals != null && vals.length > 0) {
                    for (Object kv : vals) {
                        log.info(String.format("kv variable '%s' as is", kv));
                        if (((String)kv).indexOf("=") == -1) {
                            throw new IllegalArgumentException(String.format("The value for customField '%s' is must be of the form 'key=value'.  Instead we see '%s'", var.getKey(), kv));
                        }
                        pair = ((String)kv).split("=");
                        mapStrings.put(pair[0].trim(), pair[1].trim());
                    }
                }
                varsMap.put(var.getKey().toString(), mapStrings);
                continue;
            }
            if (var.getValue() instanceof Collection) {
                log.info("processing variable as instanceof Collection");
                log.info(String.format("var.getKey()= '%s', val.getValue()= '%s'", var.getKey().toString(), var.getValue() != null ? var.getValue().toString() : ""));
                val = var.getValue() != null ? var.getValue().toString() : "";
                String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                vals = val.split(delim);
                arrs = new ArrayList<Object>();
                for (Object kv : vals) {
                    arrs.add(kv);
                }
                varsMap.put(var.getKey().toString(), arrs);
                continue;
            }
            if (var.getValue() instanceof ArrayList) {
                log.info("processing variable as instanceof ArrayList");
                ArrayList<String> arrs2 = new ArrayList<String>();
                for (Object item : (ArrayList)var.getValue()) {
                    if (item instanceof Option) {
                        arrs2.add(((Option)item).getValue());
                        continue;
                    }
                    log.info(String.format("[WARN:XLR Plugin] custom field '%s' has unserializable item '%s'.  Skipping.", var.getKey(), item.toString()));
                }
                varsMap.put(var.getKey().toString(), arrs2);
                continue;
            }
            if (var.getValue() instanceof Option || var.getValue() instanceof String) {
                val = null;
                val = var.getValue() instanceof Option ? ((Option)var.getValue()).getValue() : (String)var.getValue();
                if (var.getType().equals("xlrelease.BooleanVariable")) {
                    if ("yes|true".indexOf(val.toLowerCase()) >= 0) {
                        varsMap.put(var.getKey(), true);
                        continue;
                    }
                    varsMap.put(var.getKey(), false);
                    continue;
                }
                if (var.getType().equals("xlrelease.IntegerVariable")) {
                    try {
                        int i = Integer.parseInt(var.getValue().toString());
                        varsMap.put(var.getKey().toString(), i);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        log.error("NumberFormatException: " + nfe.getMessage());
                        throw new IllegalArgumentException(String.format("The value for customField must be an integer.  Instead we see '%s'", var.getValue()));
                    }
                }
                if (var.getType().equals("xlrelease.MapStringStringVariable")) {
                    String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                    vals = val.split(delim);
                    log.info(String.format("map variable='%s'", vals));
                    mapStrings = new HashMap();
                    if (!"{}".equals(val) && vals != null && vals.length > 0) {
                        for (Object kv : vals) {
                            if (((String)kv).indexOf("=") == -1) {
                                throw new IllegalArgumentException(String.format("The value for customField '%s' is must be of the form 'key=value'.  Instead we see '%s'", var.getKey(), kv));
                            }
                            pair = ((String)kv).split("=");
                            mapStrings.put(pair[0].trim(), pair[1].trim());
                        }
                    }
                    varsMap.put(var.getKey().toString(), mapStrings);
                    continue;
                }
                if (var.getType().equals("xlrelease.ListStringVariable")) {
                    String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                    vals = val.split(delim);
                    arrs = new ArrayList();
                    for (Object kv : vals) {
                        arrs.add(kv);
                    }
                    varsMap.put(var.getKey().toString(), arrs);
                    continue;
                }
                if (var.getType().equals("xlrelease.SetStringVariable")) {
                    String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                    vals = val.split(delim);
                    HashSet<Object> setStrings = new HashSet<Object>();
                    for (Object v : vals) {
                        setStrings.add(v);
                    }
                    varsMap.put(var.getKey().toString(), setStrings);
                    continue;
                }
                if (!var.getType().equals("xlrelease.StringVariable")) continue;
                varsMap.put(var.getKey().toString(), val);
                continue;
            }
            varsMap.put(var.getKey().toString(), var.getValue() != null ? var.getValue().toString() : "");
        }
        return varsMap;
    }

    private WebResource newWebResource() {
        log.info(String.format("[XLR] newWebResource for '%s'", this.serverUrl));
        JacksonJaxbJsonProvider jacksonProvider = new JacksonJaxbJsonProvider();
        jacksonProvider.setMapper(new ObjectMapperProvider().getMapper());
        DefaultClientConfig config = new DefaultClientConfig();
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        config.getSingletons().add(jacksonProvider);
        Client client = Client.create((ClientConfig)config);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.user, this.password));
        WebResource service = client.resource(this.serverUrl);
        return service;
    }
}

