/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.jira.xlr.addons.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.google.common.base.Strings;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.xebialabs.jira.xlr.client.TemplateNotFoundException;
import com.xebialabs.jira.xlr.client.XLReleaseClient;
import com.xebialabs.jira.xlr.client.XLReleaseClientException;
import com.xebialabs.jira.xlr.dto.Release;
import com.xebialabs.jira.xlr.dto.TemplateVariable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartReleasePostFunction
extends AbstractJiraFunctionProvider {
    private static final Logger log = LoggerFactory.getLogger(StartReleasePostFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        MutableIssue issue = this.getIssue(transientVars);
        try {
            this.doExecute(args, issue);
        }
        catch (IllegalArgumentException e) {
            this.writeErrorAsComment((Issue)issue, "Start Release In XLR Post Function configuration error:\n" + e.getMessage());
        }
        catch (TemplateNotFoundException e) {
            this.writeErrorAsComment((Issue)issue, e.getMessage());
        }
        catch (XLReleaseClientException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("XLR runtime error occurred. Stack Trace :");
            e.printStackTrace(pw);
            pw.close();
            this.writeErrorAsComment((Issue)issue, sw.toString());
        }
    }

    private void writeErrorAsComment(Issue issue, String msg) {
        this.writeComment(issue, "{color:red}\n" + msg + "\n{color}");
    }

    private void writeComment(Issue issue, String msg) {
        CommentManager commentManager = ComponentAccessor.getCommentManager();
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        commentManager.create(issue, user, msg, false);
    }

    private void doExecute(Map args, MutableIssue issue) throws XLReleaseClientException {
        IssueFieldMapper argsMapper = new IssueFieldMapper(args, (Issue)issue);
        XLReleaseClient xlReleaseClient = this.initClient(argsMapper);
        String releaseId = argsMapper.getReleaseId();
        if (releaseId != null) {
            this.writeComment((Issue)issue, "Release already created with id " + releaseId + ". Will ignore transition.");
            return;
        }
        Release releaseTemplate = null;
        String xlrTemplate = argsMapper.getReleaseTemplateName();
        if (xlrTemplate != null && xlrTemplate.split("/").length > 1) {
            String folder = xlrTemplate.substring(0, xlrTemplate.lastIndexOf("/")).trim();
            String templateName = xlrTemplate.substring(xlrTemplate.lastIndexOf("/") + 1).trim();
            releaseTemplate = xlReleaseClient.findTemplateByFolderAndTitle(folder, templateName);
        } else {
            releaseTemplate = xlReleaseClient.findTemplateByTitle(xlrTemplate);
        }
        List<TemplateVariable> variables = xlReleaseClient.getVariables(releaseTemplate.getPublicId());
        argsMapper.populateVariables(variables);
        String title = argsMapper.getOptionalCustomFieldValue("xlrReleaseTitleField");
        if (Strings.isNullOrEmpty((String)title)) {
            title = "Release Jira Issue " + issue.getKey();
        }
        Set labels = issue.getLabels();
        ArrayList<String> xlabels = new ArrayList<String>();
        for (Label label : labels) {
            xlabels.add(label.getLabel());
        }
        String applicationString = "";
        if (!releaseTemplate.getPrivateId().startsWith("Applications/")) {
            applicationString = "Applications/";
        }
        Release release = xlReleaseClient.createRelease(applicationString + releaseTemplate.getPrivateId(), title, variables, xlabels, releaseTemplate.getScriptUsername(), releaseTemplate.getScriptUserPassword());
        issue.setCustomFieldValue(argsMapper.getReleaseIdField(), (Object)release.getPrivateId());
        this.writeComment((Issue)issue, String.format("[%s|%s#/releases/%s] created.", title, argsMapper.getUrl(), release.getPrivateId() != null ? release.getPrivateId().replace('/', '-') : release.getPrivateId()));
        xlReleaseClient.startRelease(release.getPublicId());
    }

    private XLReleaseClient initClient(IssueFieldMapper argsMapper) {
        return new XLReleaseClient(argsMapper.getUrl(), argsMapper.getUsername(), argsMapper.getPassword());
    }

    private static class IssueFieldMapper {
        private final Map settings;
        private Issue issue;
        Map<String, CustomField> issueCustomFields;

        IssueFieldMapper(Map settings, Issue issue) {
            this.settings = settings;
            this.issue = issue;
            this.issueCustomFields = this.getCustomFieldsForIssueIndexedByFieldName(issue);
        }

        public String getReleaseTemplateName() {
            return (String)this.getCustomRequiredFieldValue("xlrTemplateField");
        }

        public CustomField getReleaseIdField() {
            return this.getCustomField("xlrReleaseIdField");
        }

        public String getReleaseId() {
            return (String)this.getCustomFieldValue("xlrReleaseIdField");
        }

        public String getUrl() {
            return this.resolveValueFromCustomIssueFieldOrGlobalSetting("xlrUrlField", "xlrUrlGlobal", "Url");
        }

        public String getPassword() {
            return this.resolveValueFromCustomIssueFieldOrGlobalSetting("xlrPasswordField", "xlrPasswordGlobal", "Password");
        }

        public String getUsername() {
            return this.resolveValueFromCustomIssueFieldOrGlobalSetting("xlrUserNameField", "xlrUsernameGlobal", "Username");
        }

        public void populateVariables(List<TemplateVariable> variables) {
            Iterator<TemplateVariable> itr = variables.iterator();
            while (itr.hasNext()) {
                TemplateVariable variable = itr.next();
                String key = variable.getKey();
                if (key.equals("issue")) {
                    variable.setValue(this.issue.getKey());
                    continue;
                }
                if (!this.issueCustomFields.containsKey(key)) continue;
                Object value = this.issue.getCustomFieldValue(this.issueCustomFields.get(key));
                variable.setValue(value);
                if (value != null || variable.getRequiresValue().booleanValue()) continue;
                log.info(String.format("[XLR] removed custom variable: '%s' as it is empty and is not required.", key));
                itr.remove();
            }
        }

        private String resolveValueFromCustomIssueFieldOrGlobalSetting(String settingsField, String globalSettingsField, String settingName) {
            String value = this.getOptionalCustomFieldValue(settingsField);
            if (Strings.isNullOrEmpty((String)value) && Strings.isNullOrEmpty((String)(value = (String)this.settings.get(globalSettingsField)))) {
                throw new IllegalArgumentException(String.format("%s is not defined on issue nor is it defined in post function arguments as a global setting.", settingName));
            }
            return value;
        }

        private Object getCustomRequiredFieldValue(String name) {
            Object value = this.getCustomFieldValue(name);
            if (value == null) {
                String issueFieldName = this.resolveIssueFieldNameFromSettingsFieldName(name);
                throw new IllegalArgumentException(String.format("Custom field '%s', referenced from post function argument %s, has empty value on issue %s.", issueFieldName, name, this.issue.getId()));
            }
            return value;
        }

        private String getOptionalCustomFieldValue(String name) {
            CustomField issueField = this.getOptionalCustomField(name);
            if (issueField == null) {
                return null;
            }
            return (String)this.issue.getCustomFieldValue(issueField);
        }

        private Object getCustomFieldValue(String name) {
            CustomField issueField = this.getCustomField(name);
            return this.issue.getCustomFieldValue(issueField);
        }

        private CustomField getCustomField(String name) {
            CustomField issueField = this.getOptionalCustomField(name);
            if (issueField == null) {
                String issueFieldName = this.resolveIssueFieldNameFromSettingsFieldName(name);
                throw new IllegalArgumentException(String.format("Custom field '%s', referenced from post function argument %s, is not defined on issue.", issueFieldName, name));
            }
            return issueField;
        }

        private CustomField getOptionalCustomField(String name) {
            String issueFieldName = this.resolveIssueFieldNameFromSettingsFieldName(name);
            return this.issueCustomFields.get(issueFieldName);
        }

        private String resolveIssueFieldNameFromSettingsFieldName(String settingsFieldName) {
            String fieldName = (String)this.settings.get(settingsFieldName);
            if (Strings.isNullOrEmpty((String)fieldName)) {
                throw new IllegalArgumentException(String.format("Argument '%s' is not defined.", settingsFieldName));
            }
            return fieldName;
        }

        private Map<String, CustomField> getCustomFieldsForIssueIndexedByFieldName(Issue issue) {
            CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
            List customFieldObjects = customFieldManager.getCustomFieldObjects(issue);
            HashMap<String, CustomField> index = new HashMap<String, CustomField>(customFieldObjects.size());
            for (CustomField customFieldObject : customFieldObjects) {
                index.put(customFieldObject.getFieldName(), customFieldObject);
            }
            return index;
        }
    }
}

