/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.jira.xlr.client;

import com.atlassian.jira.issue.customfields.option.Option;
import com.xebialabs.jira.xlr.dto.TemplateVariable;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableSerializer
extends JsonSerializer<TemplateVariable> {
    private static final Logger log = LoggerFactory.getLogger(VariableSerializer.class);

    public void serialize(TemplateVariable var, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("key", var.getKey());
        if (var.getValue() instanceof Option || var.getValue() instanceof String) {
            String val = null;
            val = var.getValue() instanceof Option ? ((Option)var.getValue()).getValue() : (String)var.getValue();
            if (var.getType().equals("xlrelease.BooleanVariable")) {
                if ("yes|true".indexOf(val.toLowerCase()) >= 0) {
                    jgen.writeBooleanField("value", true);
                } else {
                    jgen.writeBooleanField("value", false);
                }
            } else if (var.getType().equals("xlrelease.MapStringStringVariable")) {
                String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                String[] vals = val.split(delim);
                jgen.writeFieldName("value");
                jgen.writeStartObject();
                for (String kv : vals) {
                    if (kv.indexOf("=") == -1) {
                        throw new IllegalArgumentException(String.format("The value for customField '%s' is must be of the form 'key=value'.  Instead we see '%s'", var.getKey(), kv));
                    }
                    String[] pair = kv.split("=");
                    jgen.writeStringField(pair[0].trim(), pair[1].trim());
                }
                jgen.writeEndObject();
            } else if (var.getType().equals("xlrelease.SetStringVariable")) {
                String delim = val.indexOf("\r\n") > -1 ? "\r\n" : ",";
                String[] vals = val.split(delim);
                jgen.writeFieldName("value");
                jgen.writeStartArray();
                for (String v : vals) {
                    jgen.writeString(v);
                }
                jgen.writeEndArray();
            } else if (var.getType().equals("xlrelease.StringVariable")) {
                jgen.writeStringField("value", val);
            }
        } else if (var.getValue() instanceof ArrayList) {
            jgen.writeFieldName("value");
            jgen.writeStartArray();
            for (Object item : (ArrayList)var.getValue()) {
                if (item instanceof Option) {
                    jgen.writeString(((Option)item).getValue());
                    continue;
                }
                System.out.println(String.format("[WARN:XLR Plugin] custom field '%s' has unserializable item '%s'.  Skipping.", var.getKey(), item.toString()));
                jgen.writeString("skipped");
            }
            jgen.writeEndArray();
        } else if ("xlrelease.DateVariable".equals(var.getType())) {
            if (var.getValue() instanceof Timestamp) {
                Timestamp ts = (Timestamp)var.getValue();
                ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneId.systemDefault());
                String tsiso = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                log.debug(String.format("[XLR] writing date variable '%s' as '%s'", var.getKey(), tsiso));
                jgen.writeObjectField("value", (Object)tsiso);
            } else {
                log.debug(String.format("[XLR] writing date variable '%s' as is", var.getKey()));
                jgen.writeObjectField("value", var.getValue());
            }
        } else {
            log.debug(String.format("[XLR] writing unconverted type '%s' for variable '%s'", var.getType(), var.getKey()));
            jgen.writeObjectField("value", var.getValue());
        }
        jgen.writeEndObject();
    }
}

