import sys, string
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from com.xebialabs.xlrelease.plugin.webhook import XmlPathResult

if 'jsonPathExpression' in vars():
    content_type = 'application/json'
    query_description = 'JSON Path Expression'
    result_expected = jsonPathExpression is not None and len(jsonPathExpression) > 0
    def process_response(response):
        return JsonPathResult(response, jsonPathExpression).get()

elif 'xPathExpression' in vars():
    content_type = 'application/xml'
    query_description = 'XPath Expression'
    result_expected = xPathExpression is not None and len(xPathExpression) > 0
    def process_response(response):
        return XmlPathResult(response, xPathExpression).get()

else:
    print 'Could not determine Webhook format, neither JsonPath nor XPath expression was provided'
    sys.exit(1)

response = XLRequest(URL, method, body, username, password, content_type).send()

if response.isSuccessful():
    if result_expected:
        result = process_response(response.read())
        if result is None:
            print "%s did not match anything in the response" % query_description
            sys.exit(1)
        print "Result: %s" % result
    else:
        print "Status: %s" % response.status

else:
    print "Failed to connect at %s." % URL
    response.errorDump()
    sys.exit(1)
