import sys, string, time
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult

poll_interval = 5

if jenkinsServer is None:
    print "No server provided."
    sys.exit(1)

jenkinsURL = jenkinsServer['url']

jobUrl = jenkinsURL + '/job/' + jobName + '/'
buildUrl = jobUrl + 'build'

credentials = CredentialsFallback(jenkinsServer, username, password).getCredentials()

buildResponse = XLRequest(buildUrl, 'GET', '', credentials['username'], credentials['password'], 'application/json').send()

if buildResponse.isSuccessful():
    # polls until the job has been actually triggered (it could have been queued)
    while True:
        time.sleep(poll_interval)
        statusRequest = XLRequest(jobUrl + 'api/json', 'GET', '', credentials['username'], credentials['password'], 'application/json')
        response = statusRequest.send().read()

        # response.inQueue is a boolean set to True if a job has been queued
        inQueue = JsonPathResult(response, 'inQueue').get()

        if not inQueue:
            buildNumber = JsonPathResult(response, 'lastBuild.number').get()
            break

    # polls until the job completes
    while True:
        time.sleep(poll_interval)
        statusRequest = XLRequest(jobUrl + str(buildNumber) + '/api/json', 'GET', '', credentials['username'], credentials['password'], 'application/json')
        response = statusRequest.send().read()
        buildStatus = JsonPathResult(response, 'result').get()
        if buildStatus:
            break

    print "Job '%s' #%s" % (jobName, buildNumber)
    print "Finished: %s" % buildStatus
    if buildStatus == 'SUCCESS':
        sys.exit(0)
    else:
        sys.exit(1)
else:
    print "Failed to connect at %s." % buildUrl
    buildResponse.errorDump()
    sys.exit(1)
