/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.factory.SimpleRequestHandlerFactory;
import ro.isdc.wro.http.handler.spi.RequestHandlerProvider;
import ro.isdc.wro.util.provider.ProviderFinder;

public class DefaultRequestHandlerFactory
extends SimpleRequestHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestHandlerFactory.class);

    public DefaultRequestHandlerFactory() {
        List<Object> requestHandlerProviders = Collections.emptyList();
        try {
            requestHandlerProviders = ProviderFinder.of(RequestHandlerProvider.class).find();
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        ArrayList<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
        for (RequestHandlerProvider requestHandlerProvider : requestHandlerProviders) {
            LOG.debug("using provider: {}", (Object)requestHandlerProvider);
            requestHandlers.addAll(requestHandlerProvider.provideRequestHandlers().values());
        }
        this.setHandlers(requestHandlers);
    }
}

