/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.google.common.base.Strings;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.core.rest.resteasy.Mime4jStorageProvider;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.jetty.FlexRestCompatibilityFilter;
import com.xebialabs.deployit.jetty.NoOptionsFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.filter.LicenseCheckFilter;
import java.net.ServerSocket;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.crypto.SecretKey;
import javax.jcr.Repository;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import nl.javadude.t2bus.Subscribe;
import org.apache.jackrabbit.j2ee.JcrRemotingServlet;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.DelegatingFilterProxy;
import spray.servlet.Initializer;
import spray.servlet.Servlet30ConnectorServlet;

public class Server {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String SPRING_CONFIG = "classpath:spring/deployit-context.xml,classpath:deployit-security.xml,classpath*:hotfix-context.xml";
    private final ServerConfiguration serverConfiguration;
    private final String name;
    private final String springConfig;
    private final String contextPath;
    private org.eclipse.jetty.server.Server jettyServer;
    private WebAppContext contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger = LoggerFactory.getLogger(Server.class);

    public static void start(String name, ServerLaunchOptions deployitOptions, ServerConfigFile configFile) {
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)deployitOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key. " + name + " will not start.");
            return;
        }
        ServerConfiguration config = configFile.loadConfig();
        Server server = new Server(name, config, deployitOptions.isTestModeEnabled());
        server.start();
    }

    public Server(String name, ServerConfiguration configuration, boolean testMode) {
        this(name, configuration, testMode, SPRING_CONFIG, "deployit");
    }

    public Server(String name, ServerConfiguration configuration, boolean testMode, String springConfig, String contextPath) {
        this.serverConfiguration = configuration;
        this.name = name;
        this.springConfig = springConfig;
        this.contextPath = contextPath;
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (this.portIsAvailable()) {
            this.setupJetty(testMode);
            Server.bootPlugins();
            this.setupSpring();
            this.setupRest();
        } else {
            logger.error("Cannot start {}; port {} already in use.", (Object)name, (Object)this.serverConfiguration.getHttpPort());
            logger.error("Perhaps another instance of {} is running.", (Object)name);
            System.exit(1);
        }
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.serverConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setupJetty(boolean testMode) {
        ServerConnector connector;
        int port = this.serverConfiguration.getHttpPort();
        String webContextRoot = this.serverConfiguration.getWebContextRoot();
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, webContextRoot, documentRootPackage});
        }
        this.jettyServer = new org.eclipse.jetty.server.Server((ThreadPool)this.buildThreadPool());
        if (this.serverConfiguration.isSsl()) {
            logger.debug("Setting up Jetty to use SSL");
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.serverConfiguration.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(this.serverConfiguration.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(this.serverConfiguration.getKeyStoreKeyPassword());
            String protocol = this.serverConfiguration.getSslProtocol();
            if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
                sslContextFactory.setProtocol(protocol);
            }
            connector = new ServerConnector(this.jettyServer, sslContextFactory);
        } else {
            connector = new ServerConnector(this.jettyServer);
        }
        connector.setIdleTimeout(30000L);
        connector.setHost(this.serverConfiguration.getHttpBindAddress());
        connector.setPort(port);
        logger.info("Connector listen {} on {}:{}", new Object[]{this.serverConfiguration.isSsl() ? "secure" : "no-secure", connector.getHost(), connector.getPort()});
        this.jettyServer.addConnector((Connector)connector);
        this.jettyServer.setStopTimeout(1000L);
        this.contextRoot = new WebAppContext((HandlerContainer)this.jettyServer, webContextRoot, new SessionHandler(), (SecurityHandler)new ConstraintSecurityHandler(), new ServletHandler(), (ErrorHandler)new CustomErrorHandler(), 0);
        this.contextRoot.addFilter(LicenseCheckFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(NoOptionsFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/repository/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(FlexRestCompatibilityFilter.class, "/deployit/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder sprayServletHolder = new ServletHolder(Servlet30ConnectorServlet.class);
        sprayServletHolder.setDisplayName("SprayConnectorServlet");
        sprayServletHolder.setAsyncSupported(true);
        this.contextRoot.addEventListener((EventListener)new Initializer());
        this.contextRoot.addServlet(sprayServletHolder, "/api/*");
        ServletHolder defaultServletHolder = new ServletHolder();
        defaultServletHolder.setServlet((Servlet)new ClassPathResourceContentServlet(documentRootPackage));
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        this.contextRoot.addServlet(defaultServletHolder, "/");
        this.contextRoot.setErrorHandler((ErrorHandler)new CustomErrorHandler());
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        RequestLogImpl requestLogger = new RequestLogImpl();
        requestLogger.setFileName("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        this.contextRoot.setHandler((Handler)requestLogHandler);
        if (testMode) {
            this.setupJackRabbitAccess();
        }
    }

    private QueuedThreadPool buildThreadPool() {
        return new QueuedThreadPool(this.serverConfiguration.getMaxThreads(), this.serverConfiguration.getMinThreads());
    }

    private void setupJackRabbitAccess() {
        ServletHolder remotingServletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            protected Repository getRepository() {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)context.getBean("jcrRepository");
            }
        });
        remotingServletHolder.setName("RepositoryAccessServlet");
        String repositoryPrefix = "/repository-test";
        remotingServletHolder.setInitParameter("resource-path-prefix", repositoryPrefix);
        this.contextRoot.addServlet(remotingServletHolder, repositoryPrefix + "/*");
        ServletHolder webdavServletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            public Repository getRepository() {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)context.getBean("jcrRepository");
            }
        });
        webdavServletHolder.setName("Webdav");
        repositoryPrefix = "/repository";
        webdavServletHolder.setInitParameter("resource-path-prefix", repositoryPrefix);
        webdavServletHolder.setInitParameter("missing-auth-mapping", "guestcredentials");
        this.contextRoot.addServlet(webdavServletHolder, repositoryPrefix + "/*");
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupSpring() {
        ServerConfiguration.setInstance((ServerConfiguration)this.serverConfiguration);
        Map params = this.contextRoot.getInitParams();
        params.put(SPRING_CTX_CFG_LOCATION_KEY, this.springConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + (String)params.get(SPRING_CTX_CFG_LOCATION_KEY));
        }
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/" + this.contextPath + "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupRest() {
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)((Object)new DeployitSpringContextLoaderListener()));
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/" + this.contextPath);
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/" + this.contextPath + "/*");
        this.contextRoot.setResourceBase(".");
        DefaultStorageProvider.setInstance((StorageProvider)new Mime4jStorageProvider());
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            if (logger.isDebugEnabled()) {
                logger.debug("Jetty started");
            }
            logger.info("{} has started.", (Object)this.name);
            this.createShutdownEventThreadAndShutdownHook();
            logger.info("You can now point your browser to {}", (Object)this.serverConfiguration.getServerUrl());
            EventBusHolder.publish((Object)new SystemStartedEvent());
        }
        catch (Exception e) {
            logger.error("Error occured while starting Jetty", (Throwable)e);
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.jettyServer.stop();
                logger.info("{} has shut down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.trace("Shutting down {} because a shutdown event was received.", (Object)Server.this.name);
                Server.this.stop();
            }
        });
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.trace("Shutting down {} because the process is being terminated.", (Object)Server.this.name);
                Server.this.stop();
            }
        }));
        EventBusHolder.register((Object)this);
    }

    public WebAppContext getContextRoot() {
        return this.contextRoot;
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.trace("Received shutdown event.");
        shutdownLatch.countDown();
    }
}

