/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessSource {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^(?!\\s*//\\s*)@import\\s+(url\\()?\\s*(\"|')(.+)\\s*(\"|')(\\))?\\s*;.*$", 8);
    private File file;
    private String content;
    private String normalizedContent;
    private Map<String, LessSource> imports = new LinkedHashMap<String, LessSource>();

    public LessSource(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found.");
        }
        this.file = file;
        this.content = this.normalizedContent = FileUtils.readFileToString((File)file);
        this.resolveImports();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String getContent() {
        return this.content;
    }

    public String getNormalizedContent() {
        return this.normalizedContent;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public long getLastModifiedIncludingImports() {
        long lastModified = this.getLastModified();
        for (Map.Entry<String, LessSource> entry : this.imports.entrySet()) {
            LessSource importedLessSource = entry.getValue();
            long importedLessSourceLastModified = importedLessSource.getLastModifiedIncludingImports();
            if (importedLessSourceLastModified <= lastModified) continue;
            lastModified = importedLessSourceLastModified;
        }
        return lastModified;
    }

    public Map<String, LessSource> getImports() {
        return this.imports;
    }

    private void resolveImports() throws FileNotFoundException, IOException {
        Matcher importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
        while (importMatcher.find()) {
            String importedFile = importMatcher.group(3);
            importedFile = importedFile.matches(".*\\.(le?|c)ss$") ? importedFile : importedFile + ".less";
            boolean css = importedFile.matches(".*css$");
            if (css) continue;
            LessSource importedLessSource = new LessSource(new File(this.file.getParentFile(), importedFile));
            this.imports.put(importedFile, importedLessSource);
            this.normalizedContent = this.normalizedContent.substring(0, importMatcher.start()) + importedLessSource.getNormalizedContent() + this.normalizedContent.substring(importMatcher.end());
            importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
        }
    }
}

