/*
 * Decompiled with CFR 0.152.
 */
package spray.routing.directives;

import akka.actor.ActorRefFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.parboiled.common.FileUtils;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import spray.http.ContentType;
import spray.http.DateTime$;
import spray.http.HttpData$;
import spray.http.HttpEntity$;
import spray.http.HttpHeader;
import spray.http.HttpHeaders;
import spray.http.Uri;
import spray.httpx.marshalling.BasicMarshallers$;
import spray.httpx.marshalling.Marshaller;
import spray.httpx.marshalling.Marshaller$;
import spray.httpx.marshalling.ToResponseMarshallable;
import spray.httpx.marshalling.ToResponseMarshallable$;
import spray.httpx.marshalling.ToResponseMarshaller$;
import spray.routing.ApplyConverter$;
import spray.routing.ConjunctionMagnet$;
import spray.routing.Directive;
import spray.routing.Directive$;
import spray.routing.Prepender;
import spray.routing.Prepender$;
import spray.routing.RequestContext;
import spray.routing.RouteConcatenation$;
import spray.routing.RoutingSettings;
import spray.routing.StandardRoute;
import spray.routing.directives.ChunkSizeMagnet$;
import spray.routing.directives.ChunkingDirectives$;
import spray.routing.directives.ContentTypeResolver;
import spray.routing.directives.DetachMagnet$;
import spray.routing.directives.DetachMagnet2$;
import spray.routing.directives.DirectoryListing;
import spray.routing.directives.ExecutionDirectives$;
import spray.routing.directives.FileAndResourceDirectives;
import spray.routing.directives.FileAndResourceDirectives$;
import spray.routing.directives.FileAndResourceDirectives$$anonfun$listDirectoryContents$1$;
import spray.routing.directives.MethodDirectives$;
import spray.routing.directives.MiscDirectives$;
import spray.routing.directives.RespondWithDirectives$;
import spray.routing.directives.RouteDirectives$;
import spray.util.LoggingContext;
import spray.util.package$;

public abstract class FileAndResourceDirectives$class {
    public static Function1 getFromFile(FileAndResourceDirectives $this, String fileName, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory) {
        return $this.getFromFile(new File(fileName), settings, resolver, refFactory);
    }

    public static Function1 getFromFile(FileAndResourceDirectives $this, File file, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory) {
        return $this.getFromFile(file, resolver.apply(file.getName()), settings, refFactory);
    }

    public static Function1 getFromFile(FileAndResourceDirectives $this, File file, ContentType contentType, RoutingSettings settings, ActorRefFactory refFactory) {
        return (Function1)Directive$.MODULE$.pimpApply(MethodDirectives$.MODULE$.get(), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(ExecutionDirectives$.MODULE$.detach(DetachMagnet$.MODULE$.fromUnit(BoxedUnit.UNIT, DetachMagnet2$.MODULE$.fromImplicitRefFactory(refFactory))), ApplyConverter$.MODULE$.hac0()).apply(file.isFile() && file.canRead() ? Directive$.MODULE$.pimpApply($this.respondWithLastModifiedHeader(file.lastModified()), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(ChunkingDirectives$.MODULE$.autoChunk(ChunkSizeMagnet$.MODULE$.fromThresholdAndChunkSize(new Tuple2.mcJI.sp(settings.fileChunkingThresholdSize(), settings.fileChunkingChunkSize()), refFactory, Predef$.MODULE$.conforms(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(int x) {
                return this.apply$mcJI$sp(x);
            }

            public long apply$mcJI$sp(int x) {
                return Int$.MODULE$.int2long(x);
            }
        })), ApplyConverter$.MODULE$.hac0()).apply(RouteDirectives$.MODULE$.complete().apply((Object)new Serializable($this, file, contentType){
            public static final long serialVersionUID = 0L;
            private final File file$1;
            private final ContentType contentType$1;

            public final ToResponseMarshallable apply() {
                return ToResponseMarshallable$.MODULE$.isMarshallable((Object)HttpEntity$.MODULE$.apply(this.contentType$1, HttpData$.MODULE$.apply(this.file$1, HttpData$.MODULE$.apply$default$2(), HttpData$.MODULE$.apply$default$3())), ToResponseMarshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.HttpEntityMarshaller()));
            }
            {
                this.file$1 = file$1;
                this.contentType$1 = contentType$1;
            }
        }))) : RouteDirectives$.MODULE$.reject()));
    }

    public static Directive respondWithLastModifiedHeader(FileAndResourceDirectives $this, long timestamp) {
        return RespondWithDirectives$.MODULE$.respondWithHeader((HttpHeader)new HttpHeaders.Last$minusModified(DateTime$.MODULE$.apply(scala.math.package$.MODULE$.min(timestamp, System.currentTimeMillis()))));
    }

    public static Function1 getFromResource(FileAndResourceDirectives $this, String resourceName, ContentTypeResolver resolver, ActorRefFactory refFactory) {
        return $this.getFromResource(resourceName, resolver.apply(resourceName), refFactory);
    }

    public static Function1 getFromResource(FileAndResourceDirectives $this, String resourceName, ContentType contentType, ActorRefFactory refFactory) {
        StandardRoute standardRoute;
        if (resourceName.endsWith("/")) {
            standardRoute = RouteDirectives$.MODULE$.reject();
        } else {
            StandardRoute standardRoute2;
            Function1<Object, Function1<RequestContext, BoxedUnit>> function1 = Directive$.MODULE$.pimpApply(MethodDirectives$.MODULE$.get(), ApplyConverter$.MODULE$.hac0());
            Function1<Object, Function1<RequestContext, BoxedUnit>> function12 = Directive$.MODULE$.pimpApply(ExecutionDirectives$.MODULE$.detach(DetachMagnet$.MODULE$.fromUnit(BoxedUnit.UNIT, DetachMagnet2$.MODULE$.fromImplicitRefFactory(refFactory))), ApplyConverter$.MODULE$.hac0());
            ClassLoader theClassLoader = package$.MODULE$.actorSystem(refFactory).dynamicAccess().classLoader();
            URL uRL = theClassLoader.getResource(resourceName);
            if (uRL == null) {
                standardRoute2 = RouteDirectives$.MODULE$.reject();
            } else {
                URLConnection conn = uRL.openConnection();
                conn.setUseCaches(false);
                long lm = conn.getLastModified();
                conn.getInputStream().close();
                long lastModified = lm;
                Marshaller bufferMarshaller = BasicMarshallers$.MODULE$.byteArrayMarshaller(contentType);
                standardRoute2 = (Function1)Directive$.MODULE$.pimpApply($this.respondWithLastModifiedHeader(lastModified), ApplyConverter$.MODULE$.hac0()).apply(RouteDirectives$.MODULE$.complete().apply((Object)new Serializable($this, bufferMarshaller, uRL){
                    public static final long serialVersionUID = 0L;
                    private final Marshaller bufferMarshaller$1;
                    private final URL x1$1;

                    public final ToResponseMarshallable apply() {
                        return ToResponseMarshallable$.MODULE$.isMarshallable((Object)FileUtils.readAllBytes((InputStream)this.x1$1.openStream()), ToResponseMarshaller$.MODULE$.liftMarshaller(this.bufferMarshaller$1));
                    }
                    {
                        this.bufferMarshaller$1 = bufferMarshaller$1;
                        this.x1$1 = x1$1;
                    }
                }));
            }
            standardRoute = (Function1)function1.apply(function12.apply((Object)standardRoute2));
        }
        return standardRoute;
    }

    public static Function1 getFromDirectory(FileAndResourceDirectives $this, String directoryName, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        String base = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(directoryName);
        return (Function1)Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.unmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, base, settings, resolver, refFactory, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final String base$1;
            private final RoutingSettings settings$2;
            private final ContentTypeResolver resolver$1;
            private final ActorRefFactory refFactory$1;
            private final LoggingContext log$2;

            public final Function1<RequestContext, BoxedUnit> apply(Uri.Path path) {
                String string;
                String string2 = string = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$fileSystemPath(this.base$1, path, FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$fileSystemPath$default$3(), this.log$2);
                Function1<RequestContext, BoxedUnit> function1 = !("" != null ? !"".equals(string2) : string2 != null) ? RouteDirectives$.MODULE$.reject() : this.$outer.getFromFile(string, this.settings$2, this.resolver$1, this.refFactory$1);
                return function1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.base$1 = base$1;
                this.settings$2 = settings$2;
                this.resolver$1 = resolver$1;
                this.refFactory$1 = refFactory$1;
                this.log$2 = log$2;
            }
        });
    }

    public static Function1 listDirectoryContents(FileAndResourceDirectives $this, Seq directories, Marshaller renderer, ActorRefFactory refFactory, LoggingContext log) {
        return (Function1)Directive$.MODULE$.pimpApply((Directive)MethodDirectives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(ExecutionDirectives$.MODULE$.detach(DetachMagnet$.MODULE$.fromUnit(BoxedUnit.UNIT, DetachMagnet2$.MODULE$.fromImplicitRefFactory(refFactory))), (Prepender)Prepender$.MODULE$.hnilPrepend())), ApplyConverter$.MODULE$.hac0()).apply(Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.unmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, directories, renderer, log){
            public static final long serialVersionUID = 0L;
            public final Seq directories$1;
            public final Marshaller renderer$1;
            public final LoggingContext log$3;

            public final Function1<RequestContext, BoxedUnit> apply(Uri.Path path) {
                return (Function1)Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.requestUri(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileAndResourceDirectives$.anonfun.listDirectoryContents.1 $outer;
                    public final Uri.Path path$2;

                    public final StandardRoute apply(Uri fullUri) {
                        String fullPath = fullUri.path().toString();
                        int matchedLength = fullPath.lastIndexOf(this.path$2.toString());
                        Predef$.MODULE$.require(matchedLength >= 0);
                        String pathPrefix = fullPath.substring(0, matchedLength);
                        String pathString = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$fileSystemPath("/", this.path$2, '/', this.$outer.log$3));
                        Seq dirs = (Seq)this.$outer.directories$1.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileAndResourceDirectives$$anonfun$listDirectoryContents$1$.anonfun.apply.1 $outer;

                            public final Iterable<File> apply(String dir) {
                                Iterable iterable;
                                String string;
                                String string2 = string = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$fileSystemPath(FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(dir), this.$outer.path$2, FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$fileSystemPath$default$3(), this.$outer.spray$routing$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().log$3);
                                if (!("" != null ? !"".equals(string2) : string2 != null)) {
                                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                } else {
                                    File file = new File(string);
                                    iterable = file.isDirectory() && file.canRead() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)file)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                }
                                return iterable;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return dirs.isEmpty() ? RouteDirectives$.MODULE$.reject() : (StandardRoute)RouteDirectives$.MODULE$.complete().apply((Object)new Serializable(this, pathPrefix, pathString, dirs){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileAndResourceDirectives$$anonfun$listDirectoryContents$1$.anonfun.apply.1 $outer;
                            private final String pathPrefix$1;
                            private final String pathString$1;
                            private final Seq dirs$1;

                            public final ToResponseMarshallable apply() {
                                String string = this.pathString$1;
                                String string2 = "/";
                                return ToResponseMarshallable$.MODULE$.isMarshallable((Object)new DirectoryListing(new StringBuilder().append((Object)this.pathPrefix$1).append((Object)this.pathString$1).toString(), !(string != null ? !string.equals(string2) : string2 != null), (Seq<File>)((Seq)this.dirs$1.flatMap((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ArrayOps<File> apply(File x$1) {
                                        return Predef$.MODULE$.refArrayOps((Object[])x$1.listFiles());
                                    }
                                }, Seq$.MODULE$.canBuildFrom()))), ToResponseMarshaller$.MODULE$.liftMarshaller(this.$outer.spray$routing$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().renderer$1));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.pathPrefix$1 = pathPrefix$1;
                                this.pathString$1 = pathString$1;
                                this.dirs$1 = dirs$1;
                            }
                        });
                    }

                    public /* synthetic */ FileAndResourceDirectives$.anonfun.listDirectoryContents.1 spray$routing$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.path$2 = path$2;
                    }
                });
            }
            {
                this.directories$1 = directories$1;
                this.renderer$1 = renderer$1;
                this.log$3 = log$3;
            }
        }));
    }

    public static Function1 getFromBrowseableDirectory(FileAndResourceDirectives $this, String directory, Marshaller renderer, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        return $this.getFromBrowseableDirectories((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{directory}), (Marshaller<DirectoryListing>)renderer, settings, resolver, refFactory, log);
    }

    public static Function1 getFromBrowseableDirectories(FileAndResourceDirectives $this, Seq directories, Marshaller renderer, RoutingSettings settings, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        return RouteConcatenation$.MODULE$.pimpRouteWithConcatenation((Function1<RequestContext, BoxedUnit>)((Function1)((TraversableOnce)directories.map((Function1)new Serializable($this, settings, resolver, refFactory, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final RoutingSettings settings$3;
            private final ContentTypeResolver resolver$2;
            private final ActorRefFactory refFactory$2;
            private final LoggingContext log$4;

            public final Function1<RequestContext, BoxedUnit> apply(String directoryName) {
                return this.$outer.getFromDirectory(directoryName, this.settings$3, this.resolver$2, this.refFactory$2, this.log$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.settings$3 = settings$3;
                this.resolver$2 = resolver$2;
                this.refFactory$2 = refFactory$2;
                this.log$4 = log$4;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Function1<RequestContext, BoxedUnit> apply(Function1<RequestContext, BoxedUnit> x$2, Function1<RequestContext, BoxedUnit> x$3) {
                return RouteConcatenation$.MODULE$.pimpRouteWithConcatenation(x$2).$tilde(x$3);
            }
        }))).$tilde($this.listDirectoryContents((Seq<String>)directories, (Marshaller<DirectoryListing>)renderer, refFactory, log));
    }

    public static Function1 getFromResourceDirectory(FileAndResourceDirectives $this, String directoryName, ContentTypeResolver resolver, ActorRefFactory refFactory, LoggingContext log) {
        String base = directoryName.isEmpty() ? "" : FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$withTrailingSlash(directoryName);
        return (Function1)Directive$.MODULE$.pimpApply(MiscDirectives$.MODULE$.unmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, base, resolver, refFactory, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final String base$3;
            private final ContentTypeResolver resolver$3;
            private final ActorRefFactory refFactory$3;
            private final LoggingContext log$5;

            public final Function1<RequestContext, BoxedUnit> apply(Uri.Path path) {
                String string;
                String string2 = string = FileAndResourceDirectives$.MODULE$.spray$routing$directives$FileAndResourceDirectives$$fileSystemPath(this.base$3, path, '/', this.log$5);
                Function1<RequestContext, BoxedUnit> function1 = !("" != null ? !"".equals(string2) : string2 != null) ? RouteDirectives$.MODULE$.reject() : this.$outer.getFromResource(string, this.resolver$3, this.refFactory$3);
                return function1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.base$3 = base$3;
                this.resolver$3 = resolver$3;
                this.refFactory$3 = refFactory$3;
                this.log$5 = log$5;
            }
        });
    }

    public static void $init$(FileAndResourceDirectives $this) {
    }
}

