/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.WeakHashMap;
import net.fortuna.ical4j.model.CalendarDateFormatFactory;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Time;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.TimeZones;
import org.apache.commons.lang.builder.EqualsBuilder;

public class DateTime
extends Date {
    private static final long serialVersionUID = -6407231357919440387L;
    private static final String DEFAULT_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final String RELAXED_PATTERN = "yyyyMMdd";
    private static final DateFormatCache UTC_FORMAT;
    private static final DateFormatCache DEFAULT_FORMAT;
    private static final DateFormatCache LENIENT_DEFAULT_FORMAT;
    private static final DateFormatCache RELAXED_FORMAT;
    private Time time;
    private TimeZone timezone;

    static {
        SimpleDateFormat format = new SimpleDateFormat(UTC_PATTERN);
        format.setTimeZone(TimeZones.getUtcTimeZone());
        format.setLenient(false);
        UTC_FORMAT = new DateFormatCache(format);
        format = new SimpleDateFormat(DEFAULT_PATTERN);
        format.setLenient(false);
        DEFAULT_FORMAT = new DateFormatCache(format);
        format = new SimpleDateFormat(DEFAULT_PATTERN);
        LENIENT_DEFAULT_FORMAT = new DateFormatCache(format);
        format = new SimpleDateFormat(RELAXED_PATTERN);
        format.setLenient(false);
        RELAXED_FORMAT = new DateFormatCache(format);
    }

    public DateTime() {
        super(0, java.util.TimeZone.getDefault());
        this.time = new Time(this.getTime(), this.getFormat().getTimeZone());
    }

    public DateTime(boolean utc) {
        this();
        this.setUtc(utc);
    }

    public DateTime(long time) {
        super(time, 0, java.util.TimeZone.getDefault());
        this.time = new Time(time, this.getFormat().getTimeZone());
    }

    public DateTime(java.util.Date date) {
        super(date.getTime(), 0, java.util.TimeZone.getDefault());
        this.time = new Time(date.getTime(), this.getFormat().getTimeZone());
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                this.setUtc(true);
            } else {
                this.setTimeZone(dateTime.getTimeZone());
            }
        }
    }

    public DateTime(String value) throws ParseException {
        this(value, (TimeZone)null);
    }

    public DateTime(String value, TimeZone timezone) throws ParseException {
        super(0L, 0, timezone != null ? timezone : java.util.TimeZone.getDefault());
        this.time = new Time(this.getTime(), this.getFormat().getTimeZone());
        try {
            if (value.endsWith("Z")) {
                this.setTime(value, UTC_FORMAT.get(), null);
                this.setUtc(true);
            } else {
                if (timezone != null) {
                    this.setTime(value, DEFAULT_FORMAT.get(), timezone);
                } else {
                    this.setTime(value, LENIENT_DEFAULT_FORMAT.get(), this.getFormat().getTimeZone());
                }
                this.setTimeZone(timezone);
            }
        }
        catch (ParseException pe) {
            if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                this.setTime(value, RELAXED_FORMAT.get(), timezone);
                this.setTimeZone(timezone);
            }
            throw pe;
        }
    }

    public DateTime(String value, String pattern, TimeZone timezone) throws ParseException {
        super(0L, 0, timezone != null ? timezone : java.util.TimeZone.getDefault());
        this.time = new Time(this.getTime(), this.getFormat().getTimeZone());
        DateFormat format = CalendarDateFormatFactory.getInstance(pattern);
        this.setTime(value, format, timezone);
    }

    public DateTime(String value, String pattern, boolean utc) throws ParseException {
        this(0L);
        DateFormat format = CalendarDateFormatFactory.getInstance(pattern);
        if (utc) {
            this.setTime(value, format, UTC_FORMAT.get().getTimeZone());
        } else {
            this.setTime(value, format, null);
        }
        this.setUtc(utc);
    }

    private void setTime(String value, DateFormat format, java.util.TimeZone tz) throws ParseException {
        if (tz != null) {
            format.setTimeZone(tz);
        }
        this.setTime(format.parse(value).getTime());
    }

    public final void setTime(long time) {
        super.setTime(time);
        if (this.time != null) {
            this.time.setTime(time);
        }
    }

    public final boolean isUtc() {
        return this.time.isUtc();
    }

    public final void setUtc(boolean utc) {
        this.timezone = null;
        if (utc) {
            this.getFormat().setTimeZone(TimeZones.getUtcTimeZone());
        } else {
            this.resetTimeZone();
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone(), utc);
    }

    public final void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            this.getFormat().setTimeZone(timezone);
        } else {
            this.resetTimeZone();
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone(), false);
    }

    private void resetTimeZone() {
        this.getFormat().setTimeZone(TimeZone.getDefault());
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        b.append('T');
        b.append(this.time.toString());
        return b.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof DateTime) {
            return new EqualsBuilder().append((Object)this.time, (Object)((DateTime)arg0).time).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class DateFormatCache {
        private final Map threadMap = new WeakHashMap();
        private final DateFormat templateFormat;

        private DateFormatCache(DateFormat dateFormat) {
            this.templateFormat = dateFormat;
        }

        public DateFormat get() {
            DateFormat dateFormat = (DateFormat)this.threadMap.get(Thread.currentThread());
            if (dateFormat == null) {
                dateFormat = (DateFormat)this.templateFormat.clone();
                this.threadMap.put(Thread.currentThread(), dateFormat);
            }
            return dateFormat;
        }
    }
}

