/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.wro;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.wro.CustomManagerFactory;
import java.io.IOException;
import java.util.Properties;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.http.ConfigurableWroFilter;
import ro.isdc.wro.manager.factory.WroManagerFactory;

public class WroFilter
extends ConfigurableWroFilter {
    public WroFilter() {
        Preconditions.checkState((boolean)Environment.isDevelopment());
        Properties properties = this.loadWro4JProperties();
        this.adjustForDevelopment(properties);
        this.setWroManagerFactory((WroManagerFactory)new CustomManagerFactory(properties));
        this.setProperties(properties);
    }

    private Properties loadWro4JProperties() {
        Properties properties = new Properties();
        try {
            properties.load(Resources.getResource((String)"wro.properties").openStream());
        }
        catch (IOException ioe) {
            Throwables.propagate((Throwable)ioe);
        }
        return properties;
    }

    private void adjustForDevelopment(Properties properties) {
        properties.setProperty(ConfigConstants.debug.name(), "true");
        properties.setProperty(ConfigConstants.resourceWatcherUpdatePeriod.name(), "1");
    }
}

