/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.wro;

import com.google.common.io.Resources;
import com.xebialabs.xlrelease.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupExtractorDecorator;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.factory.ConfigurableProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.Transformer;

public class CustomManagerFactory
extends BaseWroManagerFactory {
    private final ConfigurableProcessorsFactory processorsFactory;

    public CustomManagerFactory(Properties properties) {
        this.addModelTransformer((Transformer)new Transformer<WroModel>(){

            public WroModel transform(WroModel input) throws Exception {
                for (Group group : input.getGroups()) {
                    for (Resource resource : group.getResources()) {
                        resource.setUri("file:" + Environment.getWebPath() + resource.getUri());
                    }
                }
                return input;
            }
        });
        this.processorsFactory = new ConfigurableProcessorsFactory();
        this.processorsFactory.setProperties(properties);
    }

    protected GroupExtractor newGroupExtractor() {
        return new GroupExtractorDecorator(super.newGroupExtractor()){

            public boolean isMinimized(HttpServletRequest request) {
                return false;
            }
        };
    }

    protected ProcessorsFactory newProcessorsFactory() {
        return this.processorsFactory;
    }

    protected WroModelFactory newModelFactory() {
        return new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() throws IOException {
                return Resources.getResource((String)"wro.xml").openStream();
            }
        };
    }
}

