/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.UserProfiles;

public class UserView {
    private String username;
    private String fullName;
    public static final Function<UserView, String> TO_USER_NAME = new Function<UserView, String>(){

        public String apply(UserView user) {
            return user.getUsername();
        }
    };

    public static Function<String, UserView> toUserView(final UserProfiles userProfiles) {
        return new Function<String, UserView>(){

            public UserView apply(String user) {
                return new UserView(user, userProfiles);
            }
        };
    }

    public UserView() {
    }

    public UserView(String username) {
        this.username = username;
    }

    public UserView(String username, String fullName) {
        this.username = username;
        this.fullName = fullName;
    }

    public UserView(String username, UserProfiles userProfiles) {
        this.username = username;
        if (username != null) {
            this.fullName = Variable.containsVariables(username) ? null : userProfiles.getFullName(username);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getFullName() {
        return this.fullName;
    }
}

