/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.xebialabs.xlrelease.repository.UserProfiles;

public class TeamMemberView {
    static final Function<TeamMemberView, String> TO_NAME = new Function<TeamMemberView, String>(){

        public String apply(TeamMemberView teamMember) {
            return teamMember.getName();
        }
    };
    private String name;
    private String fullName;
    private MemberType type;

    public static Predicate<TeamMemberView> memberType(final MemberType type) {
        return new Predicate<TeamMemberView>(){

            public boolean apply(TeamMemberView teamMember) {
                return type.equals((Object)teamMember.getType());
            }
        };
    }

    public static Function<String, TeamMemberView> toTeamMemberView(final MemberType type, final UserProfiles userProfiles) {
        return new Function<String, TeamMemberView>(){

            public TeamMemberView apply(String name) {
                return new TeamMemberView(name, type, userProfiles);
            }
        };
    }

    public TeamMemberView() {
    }

    public TeamMemberView(String name, MemberType type, UserProfiles userProfiles) {
        this.name = name;
        this.type = type;
        if (this.type == MemberType.PRINCIPAL) {
            this.fullName = userProfiles.getFullName(name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public MemberType getType() {
        return this.type;
    }

    public static enum MemberType {
        PRINCIPAL,
        ROLE;

    }
}

