/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plumbing.PasswordDeserializer;
import com.xebialabs.deployit.plumbing.PasswordSerializer;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.GateConditionView;
import com.xebialabs.xlrelease.views.LinkView;
import com.xebialabs.xlrelease.views.PlanItemFullView;
import com.xebialabs.xlrelease.views.UserView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TaskFullView
extends PlanItemFullView {
    private UserView owner;
    private String team;
    private String scriptDefinitionType;
    private TaskStatus status;
    private Flag flag = new Flag(FlagStatus.OK);
    private String phaseTitle;
    private String releaseTitle;
    private String addedComment;
    private int numberOfComments;
    private UserView releaseOwner;
    private String server;
    private String deploymentPackage;
    private String environment;
    private String username;
    @JsonSerialize(using=PasswordSerializer.class)
    @JsonDeserialize(using=PasswordDeserializer.class)
    private String password;
    private int currentStep;
    private int totalStep;
    private String currentStepTitle;
    private List<GateConditionView> conditions;
    private List<DependencyView> dependencies;
    private Set<String> addresses;
    private String subject;
    private String body;
    private String script;
    private List<TaskFullView> tasks;
    private List<LinkView> links;
    private boolean isAutomated;
    private Map<String, Object> inputProperties = Maps.newHashMap();
    private Map<String, String> outputProperties = Maps.newHashMap();
    private List<AttachmentView> attachments;
    private boolean waitForScheduledStartDate = true;
    private String scriptDisplayGroup;
    private String scriptDisplayName;
    private String outputVarHelpText;
    private String color;
    private String customIconLocation;
    private int flagsCount;
    private int delaysCount;
    private int failuresCount;

    public TaskFullView() {
    }

    public TaskFullView(Task task, UserProfiles userProfiles) {
        super(task);
        this.status = task.getStatus();
        this.flag = Flag.toItemFlag(task);
        this.phaseTitle = task.getPhase().getTitle();
        this.releaseTitle = task.getPhase().getRelease().getTitle();
        if (task.hasOwner()) {
            this.owner = new UserView(task.getOwner(), userProfiles);
        }
        this.releaseOwner = new UserView(task.getPhase().getRelease().getOwner(), userProfiles);
        this.team = task.getTeam();
        this.numberOfComments = task.getComments().size();
        this.isAutomated = (Boolean)task.getProperty("automated");
        this.waitForScheduledStartDate = task.isWaitForScheduledStartDate();
        this.attachments = Lists.transform(task.getAttachments(), AttachmentView.TO_ATTACHMENT_VIEW);
        this.flagsCount = task.hasBeenFlagged() ? 1 : 0;
        this.delaysCount = task.hasBeenDelayed() ? 1 : 0;
        this.failuresCount = task.getFailuresCount();
        if (task instanceof DeployitTask) {
            DeployitTask deployitTask = (DeployitTask)task;
            this.server = deployitTask.getServer();
            this.deploymentPackage = deployitTask.getDeploymentPackage();
            this.environment = deployitTask.getEnvironment();
            this.username = deployitTask.getUsername();
            this.password = deployitTask.getPassword();
            this.currentStep = deployitTask.getCurrentStep();
            this.totalStep = deployitTask.getTotalStep();
            this.currentStepTitle = deployitTask.getCurrentStepTitle();
        } else if (task instanceof GateTask) {
            this.conditions = Lists.transform(((GateTask)task).getConditions(), GateConditionView.TO_CONDITION_VIEW);
            this.dependencies = Lists.transform(((GateTask)task).getDependencies(), DependencyView.TO_DEPENDENCY_VIEW);
        } else if (task instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task;
            this.addresses = notificationTask.getAddresses();
            this.subject = notificationTask.getSubject();
            this.body = notificationTask.getBody();
        } else if (task instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task;
            this.script = scriptTask.getScript();
        } else if (task instanceof ParallelGroup) {
            ParallelGroup parallelGroup = (ParallelGroup)task;
            ArrayList links = Lists.newArrayList(parallelGroup.getLinks());
            this.tasks = Lists.transform(parallelGroup.getTasks(), TaskFullView.toTaskFullView(userProfiles));
            this.links = Lists.transform((List)links, LinkView.TO_LINK_VIEW);
            for (Task subTask : task.getAllTasks()) {
                if (subTask.hasBeenFlagged()) {
                    ++this.flagsCount;
                }
                if (subTask.hasBeenDelayed()) {
                    ++this.delaysCount;
                }
                this.failuresCount += subTask.getFailuresCount();
            }
        } else if (task instanceof CustomScriptTask) {
            String propertyName;
            CustomScriptTask customScriptTask = (CustomScriptTask)task;
            PythonScript pythonScript = customScriptTask.getPythonScript();
            this.scriptDefinitionType = pythonScript.getType().toString();
            PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
            for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
                Object value;
                propertyName = propertyDescriptor.getName();
                if (propertyDescriptor.getKind() == PropertyKind.CI) {
                    value = (Configuration)((Object)pythonScript.getProperty(propertyName));
                    this.inputProperties.put(propertyName, value != null ? IdType.CONFIGURATION.convertToViewId(value.getId()) : null);
                    continue;
                }
                value = pythonScript.getProperty(propertyName);
                if (propertyDescriptor.isPassword() && value != null) {
                    value = passwordEncrypter.ensureEncrypted((String)value);
                }
                this.inputProperties.put(propertyName, value);
            }
            for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
                propertyName = propertyDescriptor.getName();
                this.outputProperties.put(propertyName, (String)pythonScript.getProperty(propertyName));
            }
            this.scriptDisplayGroup = PythonScriptDefinition.getDisplayGroup(pythonScript.getType());
            this.scriptDisplayName = PythonScriptDefinition.getDisplayName(pythonScript.getType());
            this.outputVarHelpText = pythonScript.getOutputVarHelpText();
            this.color = pythonScript.getTaskColor();
            this.customIconLocation = pythonScript.getIconLocation();
        }
    }

    public static Function<Task, TaskFullView> toTaskFullView(final UserProfiles userProfiles) {
        return new Function<Task, TaskFullView>(){

            public TaskFullView apply(Task task) {
                return new TaskFullView(task, userProfiles);
            }
        };
    }

    public UserView getOwner() {
        return this.owner;
    }

    public void setOwner(UserView owner) {
        this.owner = owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    @JsonIgnore
    public String getOwnerUsername() {
        return this.hasOwner() ? this.getOwner().getUsername() : null;
    }

    public String getScriptDefinitionType() {
        return this.scriptDefinitionType;
    }

    public void setScriptDefinitionType(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String getPhaseTitle() {
        return this.phaseTitle;
    }

    public void setPhaseTitle(String phaseTitle) {
        this.phaseTitle = phaseTitle;
    }

    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public void setAddedComment(String addedComment) {
        this.addedComment = addedComment;
    }

    public String getAddedComment() {
        return this.addedComment;
    }

    public boolean hasAddedComment() {
        return this.addedComment != null;
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDeploymentPackage() {
        return this.deploymentPackage;
    }

    public void setDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public int getTotalStep() {
        return this.totalStep;
    }

    public void setTotalStep(int totalStep) {
        this.totalStep = totalStep;
    }

    public String getCurrentStepTitle() {
        return this.currentStepTitle;
    }

    public void setCurrentStepTitle(String currentStepTitle) {
        this.currentStepTitle = currentStepTitle;
    }

    public List<GateConditionView> getConditions() {
        return this.conditions;
    }

    public UserView getReleaseOwner() {
        return this.releaseOwner;
    }

    public List<DependencyView> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<String> addresses) {
        this.addresses = addresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<TaskFullView> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskFullView> tasks) {
        this.tasks = tasks;
    }

    public List<LinkView> getLinks() {
        return this.links;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAutomated() {
        return this.isAutomated;
    }

    public void setAutomated(boolean automated) {
        this.isAutomated = automated;
    }

    public Map<String, Object> getInputProperties() {
        return this.inputProperties;
    }

    public void setInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = inputProperties;
    }

    public Map<String, String> getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = outputProperties;
    }

    public boolean isWaitForScheduledStartDate() {
        return this.waitForScheduledStartDate;
    }

    public void setWaitForScheduledStartDate(boolean waitForScheduledStartDate) {
        this.waitForScheduledStartDate = waitForScheduledStartDate;
    }

    public String getScriptDisplayGroup() {
        return this.scriptDisplayGroup;
    }

    public void setScriptDisplayGroup(String scriptDisplayGroup) {
        this.scriptDisplayGroup = scriptDisplayGroup;
    }

    public String getScriptDisplayName() {
        return this.scriptDisplayName;
    }

    public void setScriptDisplayName(String scriptDisplayName) {
        this.scriptDisplayName = scriptDisplayName;
    }

    public String getOutputVarHelpText() {
        return this.outputVarHelpText;
    }

    public void setOutputVarHelpText(String outputVarHelpText) {
        this.outputVarHelpText = outputVarHelpText;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getCustomIconLocation() {
        return this.customIconLocation;
    }

    public void setCustomIconLocation(String customIconLocation) {
        this.customIconLocation = customIconLocation;
    }

    public List<AttachmentView> getAttachments() {
        return this.attachments;
    }

    public int getFlagsCount() {
        return this.flagsCount;
    }

    public int getDelaysCount() {
        return this.delaysCount;
    }

    public int getFailuresCount() {
        return this.failuresCount;
    }

    public boolean ownerHasBeenReassigned(Task task) {
        return !task.hasOwner() && this.hasOwner() || task.hasOwner() && !this.hasOwner() || task.hasOwner() && this.hasOwner() && !task.getOwner().equals(this.getOwner().getUsername());
    }

    public boolean teamHasBeenReassigned(Task task) {
        return task.getTeam() == null && this.getTeam() != null || task.getTeam() != null && this.getTeam() == null || task.getTeam() != null && this.getTeam() != null && !task.getTeam().equals(this.getTeam());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskFullView taskView = (TaskFullView)o;
        if (this.addedComment != null ? !this.addedComment.equals(taskView.addedComment) : taskView.addedComment != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(taskView.description) : taskView.description != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals(taskView.dueDate) : taskView.dueDate != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(taskView.id) : taskView.id != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(taskView.owner) : taskView.owner != null) {
            return false;
        }
        if (this.phaseTitle != null ? !this.phaseTitle.equals(taskView.phaseTitle) : taskView.phaseTitle != null) {
            return false;
        }
        if (this.releaseTitle != null ? !this.releaseTitle.equals(taskView.releaseTitle) : taskView.releaseTitle != null) {
            return false;
        }
        if (this.status != taskView.status) {
            return false;
        }
        if (this.type != null ? !this.type.equals(taskView.type) : taskView.type != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(taskView.title) : taskView.title != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        result = 31 * result + (this.phaseTitle != null ? this.phaseTitle.hashCode() : 0);
        result = 31 * result + (this.releaseTitle != null ? this.releaseTitle.hashCode() : 0);
        result = 31 * result + (this.addedComment != null ? this.addedComment.hashCode() : 0);
        return result;
    }
}

