/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.RoleView;
import com.xebialabs.xlrelease.views.UserView;
import java.util.List;

public class RolePrincipalsView {
    private RoleView role;
    private List<UserView> principals = Lists.newArrayList();
    public static final Function<RolePrincipalsView, RolePrincipals> TO_ROLE_PRINCIPAL = new Function<RolePrincipalsView, RolePrincipals>(){

        public RolePrincipals apply(RolePrincipalsView rolePrincipalsView) {
            return rolePrincipalsView.toRolePrincipals();
        }
    };

    public static Function<RolePrincipals, RolePrincipalsView> toRolePrincipalsView(final UserProfiles userProfiles) {
        return new Function<RolePrincipals, RolePrincipalsView>(){

            public RolePrincipalsView apply(RolePrincipals rolePrincipals) {
                return new RolePrincipalsView(rolePrincipals, userProfiles);
            }
        };
    }

    public RolePrincipalsView() {
    }

    public RolePrincipalsView(RolePrincipals rolePrincipals, UserProfiles userProfiles) {
        this.role = new RoleView(rolePrincipals.getRole());
        this.principals = Lists.newArrayList((Iterable)Lists.transform((List)rolePrincipals.getPrincipals(), UserView.toUserView(userProfiles)));
    }

    public RoleView getRole() {
        return this.role;
    }

    public void setRole(RoleView role) {
        this.role = role;
    }

    public List<UserView> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(List<UserView> principals) {
        this.principals = principals;
    }

    public RolePrincipals toRolePrincipals() {
        return new RolePrincipals(this.role.toRole(), Lists.transform(this.principals, UserView.TO_USER_NAME));
    }
}

