/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.configuration.ReportsSettings;

public class ReportsSettingsView {
    private Integer warningThreshold;
    private Integer errorThreshold;
    private Integer criticalPhaseThreshold;

    public ReportsSettingsView(Integer warningThreshold, Integer errorThreshold, Integer criticalPhaseThreshold) {
        this.warningThreshold = (Integer)Objects.firstNonNull((Object)warningThreshold, (Object)this.getDefaultWarningThreshold());
        this.errorThreshold = (Integer)Objects.firstNonNull((Object)errorThreshold, (Object)this.getDefaultErrorThreshold());
        this.criticalPhaseThreshold = (Integer)Objects.firstNonNull((Object)criticalPhaseThreshold, (Object)this.getDefaultCriticalPhaseThreshold());
    }

    public ReportsSettingsView(ReportsSettings reportsSettings) {
        this(reportsSettings.getWarningThreshold(), reportsSettings.getErrorThreshold(), reportsSettings.getCriticalPhaseThreshold());
    }

    public static ReportsSettingsView defaultValues() {
        return new ReportsSettingsView(null, null, null);
    }

    private Integer getDefaultWarningThreshold() {
        return this.getDefaultForProperty("warningThreshold");
    }

    private Integer getDefaultErrorThreshold() {
        return this.getDefaultForProperty("errorThreshold");
    }

    private Integer getDefaultCriticalPhaseThreshold() {
        return this.getDefaultForProperty("criticalPhaseThreshold");
    }

    private Integer getDefaultForProperty(String property) {
        Descriptor descriptor = Type.valueOf(ReportsSettings.class).getDescriptor();
        return (Integer)descriptor.getPropertyDescriptor(property).getDefaultValue();
    }

    public Integer getWarningThreshold() {
        return this.warningThreshold;
    }

    public Integer getErrorThreshold() {
        return this.errorThreshold;
    }

    public Integer getCriticalPhaseThreshold() {
        return this.criticalPhaseThreshold;
    }
}

