/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.ReleaseSecurity;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.Comparator;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ReleaseTasks {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String title;
    private ReleaseStatus status;
    private List<TaskFullView> tasks = Lists.newArrayList();
    private List<Variable> variables = Lists.newArrayList();
    private ReleaseSecurity security;
    public static final Comparator<ReleaseTasks> BY_TITLE = new Comparator<ReleaseTasks>(){

        @Override
        public int compare(ReleaseTasks left, ReleaseTasks right) {
            String leftTitle = Strings.nullToEmpty((String)left.getTitle());
            String rightTitle = Strings.nullToEmpty((String)right.getTitle());
            return ComparisonChain.start().compare((Comparable)((Object)leftTitle), (Comparable)((Object)rightTitle)).result();
        }
    };

    public ReleaseTasks() {
    }

    public ReleaseTasks(Release release, List<Task> tasks, UserProfiles userProfiles) {
        this.title = release.getTitle();
        this.id = release.getId();
        this.tasks = Lists.transform(tasks, TaskFullView.toTaskFullView(userProfiles));
        this.status = release.getStatus();
        this.variables = Variable.mapToList(release.getVariableValues());
        this.security = release.getReleaseSecurity();
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public List<TaskFullView> getTasks() {
        return this.tasks;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public ReleaseSecurity getSecurity() {
        return this.security;
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }
}

