/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.PlanItemFullView;
import com.xebialabs.xlrelease.views.ReleaseSecurity;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.UserView;
import java.util.ArrayList;
import java.util.List;

public class ReleaseFullView
extends PlanItemFullView {
    private ReleaseStatus status;
    private String currentPhase;
    private TaskFullView currentTask;
    private List<TaskFullView> currentSimpleTasks;
    private List<PhaseFullView> phases;
    private UserView owner;
    private List<Variable> variables;
    private List<String> tags;
    private List<AttachmentView> attachments;
    private Flag releaseFlag;
    private Flag flag;
    private String calendarLinkToken;
    private boolean calendarPublished;
    private boolean tutorial;
    private ReleaseSecurity security;

    public ReleaseFullView() {
    }

    public ReleaseFullView(Release release, UserProfiles userProfiles) {
        super(release);
        this.status = release.getStatus();
        if (release.hasOwner()) {
            this.owner = new UserView(release.getOwner(), userProfiles);
        }
        this.phases = Lists.transform(release.getPhases(), PhaseFullView.toPhaseFullView(userProfiles));
        this.variables = Variable.getVariables(release);
        this.tags = release.getTags();
        this.attachments = Lists.transform(release.getReleaseAttachments(), AttachmentView.TO_ATTACHMENT_VIEW);
        this.releaseFlag = Flag.toItemFlag(release);
        this.flag = Flag.toFlag(release);
        this.calendarLinkToken = release.getCalendarLinkToken();
        this.calendarPublished = release.isCalendarPublished();
        this.tutorial = release.isTutorial();
        this.security = release.getReleaseSecurity();
        if (release.hasCurrentPhase()) {
            Phase currentPhase = release.getCurrentPhase();
            this.currentPhase = currentPhase.getTitle();
            if (currentPhase.hasCurrentTask()) {
                Task currentTask = currentPhase.getCurrentTask();
                this.currentTask = new TaskFullView(currentTask, userProfiles);
                this.currentSimpleTasks = ReleaseFullView.flattenCurrentTask(currentTask, userProfiles);
            }
        }
    }

    public static Function<Release, ReleaseFullView> toReleaseFullView(final UserProfiles userProfiles) {
        return new Function<Release, ReleaseFullView>(){

            public ReleaseFullView apply(Release release) {
                return new ReleaseFullView(release, userProfiles);
            }
        };
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public TaskFullView getCurrentTask() {
        return this.currentTask;
    }

    public List<TaskFullView> getCurrentSimpleTasks() {
        return this.currentSimpleTasks;
    }

    public List<PhaseFullView> getPhases() {
        return this.phases;
    }

    public UserView getOwner() {
        return this.owner;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<AttachmentView> getAttachments() {
        return this.attachments;
    }

    public Flag getReleaseFlag() {
        return this.releaseFlag;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public String getCalendarLinkToken() {
        return this.calendarLinkToken;
    }

    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    public ReleaseSecurity getSecurity() {
        return this.security;
    }

    public boolean isTutorial() {
        return this.tutorial;
    }

    @VisibleForTesting
    static List<TaskFullView> flattenCurrentTask(Task currentTask, UserProfiles userProfiles) {
        ArrayList currentTasks = Lists.newArrayList();
        if (currentTask.isParallelGroup()) {
            ReleaseFullView.collectCurrentSubTasks("", (ParallelGroup)currentTask, currentTasks, userProfiles);
        } else {
            currentTasks.add(new TaskFullView(currentTask, userProfiles));
        }
        return currentTasks;
    }

    private static void collectCurrentSubTasks(String parentPrefix, ParallelGroup group, List<TaskFullView> target, UserProfiles userProfiles) {
        String prefix = group.getTitle() + " / ";
        if (!parentPrefix.isEmpty()) {
            prefix = parentPrefix + prefix;
        }
        for (Task subTask : group.getTasks()) {
            if (subTask.isParallelGroup()) {
                ReleaseFullView.collectCurrentSubTasks(prefix, (ParallelGroup)subTask, target, userProfiles);
                continue;
            }
            if (!subTask.isActive()) continue;
            TaskFullView view = new TaskFullView(subTask, userProfiles);
            view.setTitle(prefix + view.getTitle());
            target.add(view);
        }
    }
}

