/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.PlanItem;
import java.util.Date;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PlanItemFullView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    protected String id;
    protected String title;
    protected String description;
    protected Date scheduledStartDate;
    protected Date dueDate;
    protected Date startDate;
    protected Date endDate;
    protected String type;
    protected boolean hasBeenStarted;
    protected boolean updatable;
    protected boolean active;
    protected boolean done;
    protected Long plannedDuration;

    protected PlanItemFullView() {
    }

    protected PlanItemFullView(PlanItem planItem) {
        this.id = planItem.getId();
        this.title = planItem.getTitle();
        this.description = planItem.getDescription();
        this.scheduledStartDate = planItem.getScheduledStartDate();
        this.dueDate = planItem.getDueDate();
        this.startDate = planItem.getStartDate();
        this.endDate = planItem.getEndDate();
        this.type = planItem.getType().toString();
        this.hasBeenStarted = planItem.hasBeenStarted();
        this.updatable = planItem.isUpdatable();
        this.active = planItem.isActive();
        this.done = planItem.isDone();
        this.plannedDuration = planItem.hasPlannedDuration() ? Long.valueOf((long)planItem.getPlannedDuration().intValue() * 1000L) : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isHasBeenStarted() {
        return this.hasBeenStarted;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isDone() {
        return this.done;
    }

    public Long getPlannedDuration() {
        return this.plannedDuration;
    }

    public void setPlannedDuration(Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }
}

