/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.views.TaskView;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PhaseView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String title;
    private List<TaskView> tasks;
    public static final Function<Phase, PhaseView> TO_PHASE_VIEW = new Function<Phase, PhaseView>(){

        public PhaseView apply(Phase phase) {
            return new PhaseView(phase);
        }
    };

    public PhaseView(Phase phase) {
        this.id = phase.getId();
        this.title = phase.getTitle();
        this.tasks = Lists.transform(phase.getAllTasks(), TaskView.TO_TASK_VIEW);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public List<TaskView> getTasks() {
        return this.tasks;
    }
}

