/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.PlanItemFullView;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.List;

public class PhaseFullView
extends PlanItemFullView {
    private PhaseStatus status;
    private List<TaskFullView> tasks;
    private List<TaskFullView> startGates;
    private List<TaskFullView> endGates;
    private boolean startGatesOpen;
    private boolean endGatesOpen;
    private String color;
    private int taskFailureCount = 0;
    private int taskFlaggedCount = 0;
    private int taskDelayCount = 0;

    public PhaseFullView() {
    }

    public PhaseFullView(Phase phase, UserProfiles userProfiles) {
        super(phase);
        this.status = phase.getStatus();
        this.tasks = Lists.transform(phase.getTasks(), TaskFullView.toTaskFullView(userProfiles));
        this.startGates = Lists.transform(phase.getStartGates(), TaskFullView.toTaskFullView(userProfiles));
        this.endGates = Lists.transform(phase.getEndGates(), TaskFullView.toTaskFullView(userProfiles));
        this.startGatesOpen = phase.areStartGatesOpen();
        this.endGatesOpen = phase.areEndGatesOpen();
        this.color = phase.getColor();
        for (Task task : phase.getAllTasks()) {
            if (task.hasBeenDelayed()) {
                ++this.taskDelayCount;
            }
            if (task.hasBeenFlagged()) {
                ++this.taskFlaggedCount;
            }
            this.taskFailureCount += task.getFailuresCount();
        }
    }

    public static Function<Phase, PhaseFullView> toPhaseFullView(final UserProfiles userProfiles) {
        return new Function<Phase, PhaseFullView>(){

            public PhaseFullView apply(Phase phase) {
                return new PhaseFullView(phase, userProfiles);
            }
        };
    }

    public PhaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(PhaseStatus status) {
        this.status = status;
    }

    public List<TaskFullView> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskFullView> tasks) {
        this.tasks = tasks;
    }

    public List<TaskFullView> getStartGates() {
        return this.startGates;
    }

    public List<TaskFullView> getEndGates() {
        return this.endGates;
    }

    public boolean isStartGatesOpen() {
        return this.startGatesOpen;
    }

    public boolean isEndGatesOpen() {
        return this.endGatesOpen;
    }

    public String getColor() {
        return this.color;
    }

    public int getTaskFailureCount() {
        return this.taskFailureCount;
    }

    public int getTaskFlaggedCount() {
        return this.taskFlaggedCount;
    }

    public int getTaskDelayCount() {
        return this.taskDelayCount;
    }
}

