/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plumbing.id.ConfigurationIdDeserializer;
import com.xebialabs.deployit.plumbing.id.ConfigurationIdSerializer;
import com.xebialabs.xlrelease.domain.Configuration;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ConfigurationView {
    @JsonSerialize(using=ConfigurationIdSerializer.class)
    @JsonDeserialize(using=ConfigurationIdDeserializer.class)
    private String id;
    private String type;
    private String title;
    private Map<String, Object> properties = Maps.newHashMap();
    public static final Function<Configuration, ConfigurationView> TO_CONFIGURATION_VIEW = new Function<Configuration, ConfigurationView>(){

        public ConfigurationView apply(Configuration configurationInstance) {
            return new ConfigurationView(configurationInstance);
        }
    };
    public static final Function<Configuration, ConfigurationView> TO_ANONYMIZED_CONFIGURATION_VIEW = new Function<Configuration, ConfigurationView>(){

        public ConfigurationView apply(Configuration configurationInstance) {
            ConfigurationView configurationView = new ConfigurationView(configurationInstance);
            configurationView.setProperties(null);
            return configurationView;
        }
    };

    public ConfigurationView() {
    }

    public ConfigurationView(Configuration configurationInstance) {
        this.id = configurationInstance.getId();
        this.type = configurationInstance.getType().toString();
        this.title = configurationInstance.getTitle();
        Collection propertyDescriptors = configurationInstance.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName = propertyDescriptor.getName();
            this.properties.put(propertyName, configurationInstance.getProperty(propertyName));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }
}

