/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Attachment;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class AttachmentView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String filename;
    private String contentType;
    public static final Function<Attachment, AttachmentView> TO_ATTACHMENT_VIEW = new Function<Attachment, AttachmentView>(){

        public AttachmentView apply(Attachment attachment) {
            return new AttachmentView(attachment.getId(), attachment.getFile().getName(), attachment.getContentType());
        }
    };

    public AttachmentView(String id, String filename, String contentType) {
        this.id = id;
        this.filename = filename;
        this.contentType = contentType;
    }

    public AttachmentView() {
    }

    public String getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static AttachmentView of(Attachment attachment) {
        return (AttachmentView)TO_ATTACHMENT_VIEW.apply((Object)attachment);
    }
}

