/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.UserView;
import java.util.Date;

public class ActivityLogEntryView {
    private UserView user;
    private String activityType;
    private String message;
    private Date eventTime;

    public ActivityLogEntryView(ActivityLogEntry activityLogEntry, UserProfiles userProfiles) {
        String username = activityLogEntry.hasUsername() ? activityLogEntry.getUsername() : "SYSTEM";
        this.user = new UserView(username, userProfiles);
        this.activityType = activityLogEntry.getActivityType();
        this.message = activityLogEntry.getMessage();
        this.eventTime = activityLogEntry.getEventTime();
    }

    public ActivityLogEntryView() {
    }

    public static Function<ActivityLogEntry, ActivityLogEntryView> toActivityLogEntryView(final UserProfiles userProfiles) {
        return new Function<ActivityLogEntry, ActivityLogEntryView>(){

            public ActivityLogEntryView apply(ActivityLogEntry activityLogEntry) {
                return new ActivityLogEntryView(activityLogEntry, userProfiles);
            }
        };
    }

    public UserView getUser() {
        return this.user;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getEventTime() {
        return this.eventTime;
    }
}

