/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.userdata;

import com.xebialabs.xlrelease.userdata.DefaultUserDataProvider;
import com.xebialabs.xlrelease.userdata.LdapUserDataProvider;
import com.xebialabs.xlrelease.userdata.LdapUserDataProviderCache;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.stereotype.Service;

@Service
public class UserDataProviderFactoryBean
implements FactoryBean<UserDataProvider>,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDataProviderFactoryBean.class);
    private ApplicationContext context;
    private UserDataProvider provider;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void afterPropertiesSet() throws Exception {
        DefaultUserDataProvider defaultUserDataProvider = new DefaultUserDataProvider();
        LdapUserDataProvider ldapUserDataProvider = this.tryInitFromSpringLdapUserSearch(defaultUserDataProvider);
        if (ldapUserDataProvider == null) {
            ldapUserDataProvider = this.tryInitFromSpringLdapProvider(defaultUserDataProvider);
        }
        if (ldapUserDataProvider != null) {
            this.provider = new LdapUserDataProviderCache(ldapUserDataProvider);
        } else {
            LOGGER.info("Defaulting to {}", (Object)DefaultUserDataProvider.class.getSimpleName());
            this.provider = defaultUserDataProvider;
        }
    }

    public UserDataProvider getObject() throws Exception {
        return this.provider;
    }

    public Class<?> getObjectType() {
        return UserDataProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private LdapUserDataProvider tryInitFromSpringLdapProvider(DefaultUserDataProvider defaultUserDataProvider) {
        LdapAuthenticationProvider ldapProvider = this.getSpringBean(LdapAuthenticationProvider.class);
        if (ldapProvider == null) {
            return null;
        }
        try {
            LOGGER.info("Found {} in spring context, initializing from LDAP", (Object)LdapAuthenticationProvider.class.getSimpleName());
            return new LdapUserDataProvider(ldapProvider, defaultUserDataProvider);
        }
        catch (Exception e) {
            LOGGER.warn("Error initializing from {}", (Object)LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            return null;
        }
    }

    private LdapUserDataProvider tryInitFromSpringLdapUserSearch(DefaultUserDataProvider defaultUserDataProvider) {
        LdapUserSearch ldapUserSearch = this.getSpringBean(LdapUserSearch.class);
        if (ldapUserSearch == null) {
            return null;
        }
        try {
            LOGGER.info("Found {} in spring context, initializing from LDAP", (Object)LdapUserSearch.class.getSimpleName());
            return new LdapUserDataProvider(ldapUserSearch, defaultUserDataProvider);
        }
        catch (Exception e) {
            LOGGER.warn("Error initializing from {}", (Object)LdapUserSearch.class.getSimpleName(), (Object)e);
            return null;
        }
    }

    private <T> T getSpringBean(Class<T> beanClass) {
        try {
            return (T)this.context.getBean(beanClass);
        }
        catch (Exception e) {
            return null;
        }
    }
}

