/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease40FixMissingDatesOnTemplates
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease40FixMissingDatesOnTemplates.class);
    private static final String VERSION = "4.0.0";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease40FixMissingDatesOnTemplates(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Fix missing dates on templates ***", (Object)"XL Release", (Object)VERSION);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class)).addProperty("status", ReleaseStatus.TEMPLATE.name());
        List templates = this.repositoryService.listEntities(query);
        Changes changes = new Changes();
        for (Release template : templates) {
            this.upgradeTemplate(template, changes);
        }
        this.repositoryService.update(changes.toUpdatedItemsArray());
        logger.info("*** Done {} {} upgrade -- Fix missing dates on templates ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    private void upgradeTemplate(Release template, Changes changes) {
        if (template.hasScheduledStartDate()) {
            return;
        }
        Date dateFromActivityLog = null;
        List<ActivityLogEntry> activityLogEntries = template.getActivityLogEntries();
        for (ActivityLogEntry activityLogEntry : activityLogEntries) {
            String activityType = activityLogEntry.getActivityType();
            if (!activityType.equals(ReleaseActivity.TEMPLATE_CREATED.name()) && !activityType.equals(ReleaseActivity.TEMPLATE_DUPLICATED.name()) && !activityType.equals(ReleaseActivity.TEMPLATE_IMPORTED.name())) continue;
            dateFromActivityLog = activityLogEntry.getEventTime();
        }
        if (dateFromActivityLog != null) {
            template.setScheduledStartDate(dateFromActivityLog);
        } else {
            template.setScheduledStartDate(template.findFirstSetDate());
        }
        changes.update((ConfigurationItem)template);
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)VERSION);
    }
}

