/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease40FixMissingDatesOnAbortedReleases
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease40FixMissingDatesOnAbortedReleases.class);
    private static final String VERSION = "4.0-beta-5";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease40FixMissingDatesOnAbortedReleases(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Fix missing dates on aborted releases ***", (Object)"XL Release", (Object)VERSION);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class)).addProperty("status", ReleaseStatus.ABORTED.name());
        List abortedReleases = this.repositoryService.listEntities(query);
        Changes changes = new Changes();
        for (Release release : abortedReleases) {
            this.upgradeRelease(release, changes);
        }
        this.repositoryService.update(changes.toUpdatedItemsArray());
        logger.info("*** Done {} {} upgrade -- Fix missing dates on aborted releases ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    private void upgradeRelease(Release release, Changes changes) {
        Date abortionEndDate = null;
        for (Task task : release.getAllTasks()) {
            if (!task.isAborted()) continue;
            if (abortionEndDate == null) {
                abortionEndDate = task.getEndDate();
            }
            this.setStartDateIfEmpty(changes, task, task.getEndDate());
        }
        if (abortionEndDate == null) {
            logger.warn("Can't upgrade release '{}:{}', no abort end date found in any task.", (Object)release.getId(), (Object)release.getTitle());
            return;
        }
        for (Phase phase : release.getPhases()) {
            if (!phase.isAborted()) continue;
            this.setStartDateIfEmpty(changes, phase, abortionEndDate);
            phase.setEndDate(abortionEndDate);
            changes.update((ConfigurationItem)phase);
        }
        this.setStartDateIfEmpty(changes, release, abortionEndDate);
        release.setEndDate(abortionEndDate);
        changes.update((ConfigurationItem)release);
    }

    private void setStartDateIfEmpty(Changes changes, PlanItem planItem, Date startDate) {
        if (!planItem.hasStartDate()) {
            planItem.setStartDate(startDate);
            changes.update((ConfigurationItem)planItem);
        }
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)VERSION);
    }
}

