/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.repository.Configurations;
import com.xebialabs.xlrelease.upgrade.FieldToServerCI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease40CustomTasksUseServerCI
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease40CustomTasksUseServerCI.class);
    private static final String VERSION = "4.0-beta-3";
    private RepositoryService repositoryService;
    private Configurations configurations;

    @Autowired
    public XLRelease40CustomTasksUseServerCI(RepositoryService repositoryService, Configurations configurations) {
        this.repositoryService = repositoryService;
        this.configurations = configurations;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Convert JIRA tasks url / username / password into a server CI ***", (Object)"XL Release", (Object)VERSION);
        new FieldToServerCI(repository, this.repositoryService, this.configurations, "jiraURL", "jiraServer", "jira.Server", "Jira Server").upgrade(Lists.newArrayList((Object[])new String[]{"jira.CreateIssue", "jira.UpdateIssue"}));
        new FieldToServerCI(repository, this.repositoryService, this.configurations, "jenkinsURL", "jenkinsServer", "jenkins.Server", "Jenkins Server").upgrade(Lists.newArrayList((Object[])new String[]{"jenkins.Build"}));
        logger.info("*** Done {} {} upgrade -- Convert JIRA tasks url / username / password into a server CI ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)VERSION);
    }
}

