/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.Release;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLRelease304TutorialFieldForReleases
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease304TutorialFieldForReleases.class);
    private static final String VERSION = "3.0.4";

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Add 'tutorial' property on Releases ***", (Object)"XL Release", (Object)VERSION);
        List releases = repository.findNodesByType(Type.valueOf(Release.class));
        try {
            for (Node release : releases) {
                if (release.hasProperty("tutorial")) continue;
                release.setProperty("tutorial", Boolean.FALSE.booleanValue());
            }
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
        }
        logger.info("*** Done {} {} upgrade -- Add 'tutorial' property on Releases ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)VERSION);
    }
}

