/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.upgrade.XLRelease303LowercaseUserProfiles;
import com.xebialabs.xlrelease.userdata.UserData;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease303GetFullNamesFromLdap
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease303LowercaseUserProfiles.class);
    private static final String VERSION = "3.0.3";
    private UserDataProvider userDataProvider;

    @Autowired
    public XLRelease303GetFullNamesFromLdap(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Retrieve full names from LDAP ***", (Object)"XL Release", (Object)VERSION);
        List userProfiles = repository.findNodesByType(Type.valueOf(UserProfile.class));
        try {
            for (Node profile : userProfiles) {
                String name = profile.getName();
                UserData userData = this.userDataProvider.getUserData(name.toLowerCase());
                if (!userData.isFound()) continue;
                profile.setProperty("fullName", userData.getFullName());
            }
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
        }
        logger.info("*** Done {} {} upgrade -- Retrieve full names from LDAP ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)VERSION);
    }
}

