/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddXLReleaseRepositoryVersion
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(AddXLReleaseRepositoryVersion.class);
    private static final String VERSION = "3.0.0";

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Create XL Release version node ***", (Object)"XL Release", (Object)VERSION);
        Node node = repository.read("/$configuration/versions");
        try {
            if (!node.hasProperty("xl-release")) {
                String currentVersion = node.getProperty("deployit").getString();
                logger.info("Creating XL Release version node with version {} ", (Object)currentVersion);
                node.setProperty("xl-release", currentVersion);
            } else {
                logger.info("Your repository already has XL Release version node");
            }
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
        }
        logger.info("*** Done {} {} upgrade -- Create XL Release version node ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)VERSION);
    }
}

