/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.activity.PermissionsLogFormatter;
import com.xebialabs.xlrelease.activity.ReleaseFieldsComparator;
import com.xebialabs.xlrelease.activity.ReleaseVariablesComparator;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.notification.Notifications;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ProxyLookup;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.ReleaseForm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseEditor {
    private RepositoryService repositoryService;
    private Tasks tasks;
    private Teams teams;
    private Phases phases;
    private Releases releases;
    private ActivityLog activityLog;
    private Scheduler scheduler;
    private Notifications notifications;
    private ProxyLookup proxyLookup;
    private UserProfiles userProfiles;

    @Autowired
    public ReleaseEditor(RepositoryService repositoryService, Tasks tasks, Teams teams, Phases phases, Releases releases, ActivityLog activityLog, Scheduler scheduler, Notifications notifications, ProxyLookup proxyLookup, UserProfiles userProfiles) {
        this.repositoryService = repositoryService;
        this.tasks = tasks;
        this.teams = teams;
        this.phases = phases;
        this.releases = releases;
        this.activityLog = activityLog;
        this.scheduler = scheduler;
        this.notifications = notifications;
        this.proxyLookup = proxyLookup;
        this.userProfiles = userProfiles;
    }

    public ReleaseEditor() {
    }

    public Team addTeam(Release release, Team team) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't add team to release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!release.hasTeam(team.getTeamName()) ? 1 : 0) != 0, (String)"Release '%s' already has a team named %s", (Object[])new Object[]{release.getTitle(), team.getTeamName()});
        Team addedTeam = this.teams.create(release, team);
        release.addTeam(addedTeam);
        this.activityLog.log(release.getId(), ReleaseActivity.TEAM_CREATED.create(team.getTeamName()));
        return addedTeam;
    }

    public Team updateTeam(String teamId, Team newTeam) {
        String releaseId = Ids.releaseIdFrom(teamId);
        Release release = (Release)this.repositoryService.read(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update teams on release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Team team = (Team)this.repositoryService.read(teamId);
        if (team.isSystemTeam()) {
            Preconditions.checkArgument((boolean)newTeam.getTeamName().equals(team.getTeamName()), (Object)"Cannot rename a system release");
        }
        team.setTeamName(newTeam.getTeamName());
        team.setMembers(newTeam.getMembers());
        team.setRoles(newTeam.getRoles());
        this.repositoryService.update((ConfigurationItem[])new Team[]{team});
        this.activityLog.log(releaseId, ReleaseActivity.TEAM_UPDATED.create(team.getTeamName(), team.getMembers().toString(), team.getRoles().toString()));
        return team;
    }

    public void deleteTeam(Release release, String teamId) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't delete team from release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Team team = (Team)this.repositoryService.read(teamId);
        release.deleteTeam(teamId);
        this.repositoryService.delete(new String[]{teamId});
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivity.TEAM_DELETED.create(team.getTeamName()));
    }

    public Task duplicateTask(String originTaskId) {
        Task taskToDuplicate = this.tasks.findById(originTaskId);
        PlanItem container = taskToDuplicate.getContainer();
        Preconditions.checkArgument((!(container instanceof ParallelGroup) || !((ParallelGroup)container).isInProgress() ? 1 : 0) != 0, (Object)"Can't duplicate task within in progress parallel group.");
        Preconditions.checkArgument((taskToDuplicate.isUpdatable() || taskToDuplicate.isDoneInAdvance() ? 1 : 0) != 0, (String)"Can't duplicate task '%s' because it is %s.", (Object[])new Object[]{taskToDuplicate.getTitle(), taskToDuplicate.getStatus()});
        String duplicatedTaskId = this.tasks.getUniqueId(Ids.getParentId(originTaskId));
        this.repositoryService.copy(originTaskId, duplicatedTaskId);
        Task duplicatedTask = (Task)this.repositoryService.read(duplicatedTaskId);
        this.saveChanges(duplicatedTask.resetToPlanned());
        this.insertTaskBelow(container, originTaskId, duplicatedTask);
        this.activityLog.log(container.getRelease().getId(), ReleaseActivity.TASK_DUPLICATED.create(duplicatedTask.getTitle()));
        return duplicatedTask;
    }

    private void insertTaskBelow(PlanItem container, String originTaskId, Task duplicatedTask) {
        List<Task> containerTasks = this.getTasks(container);
        for (int i = 0; i < containerTasks.size(); ++i) {
            Task task = containerTasks.get(i);
            if (!task.getId().equals(originTaskId)) continue;
            containerTasks.add(i + 1, duplicatedTask);
            break;
        }
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{container});
    }

    private void saveChanges(Changes changes) {
        this.repositoryService.delete(changes.toRemovedIdsArray());
        this.repositoryService.update(changes.toUpdatedItemsArray());
    }

    public Phase movePhase(Release release, MovementIndexes movementIndexes) {
        Phase movedPhase = release.movePhase(movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivity.PHASE_MOVED.create(movedPhase.getTitle()));
        return movedPhase;
    }

    public Task moveTask(MovementIndexes movementIndexes) {
        if (this.isTaskMovedWithinSameContainer(movementIndexes)) {
            return this.moveTaskWithinContainer(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        }
        return this.moveTaskBetweenContainers(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetContainerId(), movementIndexes.getTargetIndex());
    }

    private Task moveTaskWithinContainer(String containerId, Integer originIndex, Integer targetIndex) {
        PlanItem taskOrPhase = (PlanItem)this.repositoryService.read(containerId);
        List<Task> tasks = this.getTasks(taskOrPhase);
        Task taskToMove = tasks.get(originIndex);
        Preconditions.checkArgument((taskOrPhase.isUpdatable() && taskToMove.isMovable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        tasks.remove((Object)taskToMove);
        tasks.add(targetIndex, taskToMove);
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{taskOrPhase});
        this.activityLog.log(taskOrPhase.getRelease().getId(), ReleaseActivity.TASK_MOVED_WITHIN_CONTAINER.create(taskToMove.getTitle(), taskOrPhase.getTitle()));
        return taskToMove;
    }

    private List<Task> getTasks(PlanItem taskOrPhase) {
        if (taskOrPhase instanceof Phase) {
            return ((Phase)taskOrPhase).getTasks();
        }
        if (taskOrPhase instanceof ParallelGroup) {
            return ((ParallelGroup)taskOrPhase).getTasks();
        }
        throw new UnsupportedOperationException("Can't get tasks of : " + ((Object)((Object)taskOrPhase)).getClass().getName());
    }

    private boolean isTaskMovedWithinSameContainer(MovementIndexes movementIndexes) {
        return movementIndexes.getOriginContainerId().equals(movementIndexes.getTargetContainerId());
    }

    private Task moveTaskBetweenContainers(String originContainerId, Integer originIndex, String targetContainerId, Integer targetIndex) {
        PlanItem originContainer = (PlanItem)this.repositoryService.read(originContainerId);
        PlanItem targetContainer = (PlanItem)this.repositoryService.read(targetContainerId);
        List<Task> originContainerTasks = this.getTasks(originContainer);
        Task taskToMove = originContainerTasks.get(originIndex);
        List<Task> targetContainerTasks = this.getTasks(targetContainer);
        Preconditions.checkArgument((taskToMove.isMovable() && originContainer.isUpdatable() && targetContainer.isUpdatable() ? 1 : 0) != 0, (Object)"Only planned and completed in advance tasks can be moved");
        this.clearLinks(originContainer, taskToMove);
        Task movedTask = this.moveTask(taskToMove, this.tasks.getUniqueId(targetContainer.getId()));
        targetContainerTasks.add(targetIndex, movedTask);
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{targetContainer});
        this.activityLog.log(originContainer.getRelease().getId(), ReleaseActivity.TASK_MOVED_BETWEEN_CONTAINERS.create(taskToMove.getTitle(), originContainer.getTitle(), targetContainer.getTitle()));
        return movedTask;
    }

    private Task moveTask(Task taskToMove, String newId) {
        String oldId = taskToMove.getId();
        ChangeSet changeSet = new ChangeSet();
        changeSet.copy(oldId, newId);
        changeSet.delete((ConfigurationItem)taskToMove);
        this.repositoryService.execute(changeSet);
        return (Task)this.repositoryService.read(newId);
    }

    private void clearLinks(PlanItem originContainer, Task movedTask) {
        if (!(originContainer instanceof ParallelGroup)) {
            return;
        }
        ParallelGroup parallelGroup = (ParallelGroup)originContainer;
        List<Link> links = parallelGroup.getLinksOf(movedTask);
        List linkIds = Lists.transform(links, Link.TO_ID);
        this.repositoryService.delete(linkIds.toArray(new String[linkIds.size()]));
    }

    public Phase duplicatePhase(Release release, String originPhaseId) {
        Phase originPhase = this.phases.findById(originPhaseId);
        Preconditions.checkArgument((boolean)originPhase.isUpdatable(), (String)"Can't duplicate phase '%s' because it is %s.", (Object[])new Object[]{originPhase.getTitle(), originPhase.getStatus()});
        String newPhaseId = this.phases.getUniqueId(release.getId());
        this.repositoryService.copy(originPhaseId, newPhaseId);
        Phase duplicatePhase = (Phase)this.repositoryService.read(newPhaseId);
        this.saveChanges(duplicatePhase.resetToPlanned());
        release.addBelow(originPhaseId, duplicatePhase);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivity.PHASE_DUPLICATED.create(originPhase.getTitle()));
        return duplicatePhase;
    }

    public Release createTemplate(Release templateData) {
        Release template = this.releases.createTemplate(templateData);
        this.addFirstBlankPhase(template);
        this.addDefaultTeam(template, "Template Owner", XLReleasePermissions.getTemplateOnlyPermissions(), true, false);
        ArrayList adminTeamPermissions = Lists.newArrayList((Object[])new String[]{XLReleasePermissions.VIEW_TEMPLATE.getPermissionName()});
        adminTeamPermissions.addAll(XLReleasePermissions.getReleasePermissions());
        this.addDefaultTeam(template, "Release Admin", adminTeamPermissions, false, false);
        return this.releases.findById(template.getId());
    }

    private void addFirstBlankPhase(Release release) {
        Phase newPhase = this.phases.create(release.getId());
        release.addPhase(newPhase);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
    }

    @VisibleForTesting
    void addDefaultTeam(Release release, String teamName, List<String> permissions, boolean includeCurrentUser, boolean includeOwner) {
        boolean isCreation;
        Team team = null;
        if (teamName.equals("Release Admin")) {
            team = release.getAdminTeam();
        }
        boolean bl = isCreation = team == null;
        if (isCreation) {
            team = new Team();
            team.setTeamName(teamName);
        }
        team.setPermissions(permissions);
        if (includeCurrentUser) {
            team.addMember(Permissions.getAuthenticatedUserName());
        }
        if (includeOwner) {
            team.addMember(release.getOwner());
        }
        if (isCreation) {
            this.addTeam(release, team);
        } else {
            this.updateTeam(team.getId(), team);
        }
        this.activityLog.log(release.getId(), new PermissionsLogFormatter(release.getTeams()).getLogEntry());
    }

    public Release createWithoutTemplate(Release releaseData) {
        Release release = this.releases.createWithoutTemplate(releaseData);
        this.addDefaultTeam(release, "Release Admin", XLReleasePermissions.getReleasePermissions(), false, true);
        this.addFirstBlankPhase(release);
        return this.releases.findById(release.getId());
    }

    public Release createFromTemplate(String templateId, Release releaseMetadata) {
        Release release = this.releases.createFromTemplate(templateId, releaseMetadata);
        this.removeTemplateOwnerTeams(release);
        this.addDefaultTeam(release, "Release Admin", XLReleasePermissions.getReleasePermissions(), false, true);
        return this.releases.findById(release.getId(), false);
    }

    private void removeTemplateOwnerTeams(Release release) {
        Predicate<Team> isTemplateOwnerTeam = new Predicate<Team>(){

            public boolean apply(Team team) {
                return Objects.equal((Object)team.getTeamName(), (Object)"Template Owner");
            }
        };
        Collection templateOwnerTeams = Collections2.filter(release.getTeams(), (Predicate)isTemplateOwnerTeam);
        for (Team templateOwnerTeam : templateOwnerTeams) {
            this.repositoryService.delete(new String[]{templateOwnerTeam.getId()});
        }
        release.getTeams().removeAll(templateOwnerTeams);
    }

    public Release updateRelease(String releaseId, ReleaseForm releaseForm) {
        Release release = this.releases.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update release '%s' because it is %s.", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(release, releaseForm), (String)"Can't update scheduled start date on a release '%s' becasue it has already started.", (Object[])new Object[]{release.getTitle()});
        List<ActivityLogEntry> logEntries = new ReleaseFieldsComparator(release, releaseForm, this.userProfiles).getLogs();
        if (releaseForm.getTitle() != null) {
            Preconditions.checkArgument((!releaseForm.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Release title is required.");
            release.setTitle(releaseForm.getTitle());
        }
        if (releaseForm.getDescription() != null) {
            release.setDescription(releaseForm.getDescription());
        }
        release.updateDates(releaseForm.getScheduledStartDate(), releaseForm.getDueDate(), releaseForm.getPlannedDuration());
        if (releaseForm.getDueDate() != null) {
            release.setDueDate(releaseForm.getDueDate());
        }
        if (releaseForm.getScheduledStartDate() != null) {
            release.setScheduledStartDate(releaseForm.getScheduledStartDate());
        }
        if (releaseForm.hasOwner()) {
            Preconditions.checkArgument((!releaseForm.getOwnerUsername().isEmpty() ? 1 : 0) != 0, (Object)"Release owner is required.");
            release.setOwner(releaseForm.getOwnerUsername());
        }
        if (releaseForm.getTags() != null) {
            release.setTags(releaseForm.getTags());
        }
        release.addVariableValues(Variable.listToMap(releaseForm.getVariables()));
        this.notifyIfNecessary(release, releaseForm.getFlag().getStatus(), releaseForm.getFlag().getComment());
        if (releaseForm.getFlag().getStatus() != null) {
            release.setFlagStatus(releaseForm.getFlag().getStatus());
        }
        if (releaseForm.getFlag().getComment() != null) {
            release.setFlagComment(releaseForm.getFlag().getComment());
        }
        release.setCalendarPublished(releaseForm.isCalendarPublished());
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(releaseId, logEntries, User.AUTHENTICATED_USER);
        return release;
    }

    private boolean isScheduledStartDateUpdatable(Release release, ReleaseForm updatedRelease) {
        return !release.hasBeenStarted() || Objects.equal((Object)release.getScheduledStartDate(), (Object)updatedRelease.getScheduledStartDate());
    }

    private void notifyIfNecessary(Release release, FlagStatus newStatus, String flagComment) {
        if (newStatus == release.getFlagStatus() || newStatus == null || newStatus == FlagStatus.OK || release.getOwner().equals(Permissions.getAuthenticatedUserName())) {
            return;
        }
        this.notifications.notifyReleaseFlagged(release, newStatus, flagComment);
    }

    public Release updateTemplate(String templateId, ReleaseForm releaseForm, List<String> tags) {
        Release template = this.releases.findById(templateId);
        List<ActivityLogEntry> logEntries = new ReleaseFieldsComparator(template, releaseForm, this.userProfiles).getLogs();
        if (releaseForm.getTitle() != null) {
            Preconditions.checkArgument((!releaseForm.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Template title is required.");
            template.setTitle(releaseForm.getTitle());
        }
        if (releaseForm.getDescription() != null) {
            template.setDescription(releaseForm.getDescription());
        }
        template.setTags(tags);
        template.updateDatesForTemplate(releaseForm.getScheduledStartDate(), releaseForm.getDueDate(), releaseForm.getPlannedDuration());
        this.repositoryService.update((ConfigurationItem[])new Release[]{template});
        this.activityLog.log(templateId, logEntries, User.AUTHENTICATED_USER);
        return template;
    }

    public Release updateVariables(String releaseId, List<Variable> variables) {
        Release release = this.releases.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update release '%s' because it is %s.", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        ActivityLogEntry variablesLog = new ReleaseVariablesComparator(release.getVariableValues(), Variable.listToMap(variables)).getLogEntry();
        release.addVariableValues(Variable.listToMap(variables));
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        if (variablesLog != null) {
            this.activityLog.log(release.getId(), variablesLog);
        }
        return release;
    }

    public Release updatePermissions(String releaseId, List<Team> teams) {
        Release release = this.releases.findById(releaseId);
        for (Team team : teams) {
            Team oldTeam = release.getTeamWithId(team.getId());
            oldTeam.setPermissions(team.getPermissions());
            this.repositoryService.update((ConfigurationItem[])new Team[]{oldTeam});
        }
        this.activityLog.log(releaseId, new PermissionsLogFormatter(release.getTeams()).getLogEntry());
        return release;
    }

    public Release restartPhasesFrom(String releaseId, String phaseId) {
        Release release = this.releases.findById(releaseId);
        List<Phase> phasesToRestore = this.getPhasesToRestore(release, phaseId);
        List<Phase> restoredPhases = this.restorePhases(phasesToRestore);
        this.updateGatesReferencingPhases(phasesToRestore, restoredPhases);
        this.updateRelease(release, restoredPhases);
        this.closePhase(release.getCurrentPhase());
        return this.releases.findById(releaseId);
    }

    @VisibleForTesting
    List<Phase> getPhasesToRestore(Release release, String phaseId) {
        Preconditions.checkArgument((boolean)release.hasPhase(phaseId), (String)"Phase with id %s not found in release '%s'.", (Object[])new Object[]{phaseId, release.getTitle()});
        int firstPhaseToRestoreIndex = release.getPhases().indexOf((Object)release.getPhase(phaseId));
        Preconditions.checkArgument((boolean)release.hasCurrentPhase(), (String)"Release '%s' must have a current phase in order to restart phases", (Object[])new Object[]{release.getTitle()});
        int currentPhaseIndex = release.getPhases().indexOf((Object)release.getCurrentPhase());
        Preconditions.checkArgument((currentPhaseIndex >= firstPhaseToRestoreIndex ? 1 : 0) != 0, (Object)"Can't restore a phase that is after the current phase.");
        return release.getPhases().subList(firstPhaseToRestoreIndex, currentPhaseIndex + 1);
    }

    @VisibleForTesting
    List<Phase> restorePhases(List<Phase> phasesToRestore) {
        ArrayList restoredPhases = Lists.newArrayList();
        for (Phase phase : phasesToRestore) {
            restoredPhases.add(this.restorePhase(phase));
        }
        for (int i = 0; i < phasesToRestore.size(); ++i) {
            Phase originalPhase = phasesToRestore.get(i);
            Phase restoredPhase = (Phase)((Object)restoredPhases.get(i));
            this.restoreTasks(originalPhase.getTasks(), restoredPhase.getTasks());
        }
        return restoredPhases;
    }

    private Phase restorePhase(Phase phase) {
        String restoredPhaseId = this.phases.getUniqueId(Ids.releaseIdFrom(phase.getId()));
        this.repositoryService.copy(phase.getId(), restoredPhaseId);
        Phase copiedPhase = (Phase)this.repositoryService.read(restoredPhaseId);
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle(phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        this.repositoryService.update((ConfigurationItem[])new Phase[]{copiedPhase});
        return copiedPhase;
    }

    private void restoreTasks(List<Task> originalTasks, List<Task> copiedTasks) {
        for (int i = 0; i < originalTasks.size(); ++i) {
            Task restoredTask = this.tasks.findUnstartedRevision(originalTasks.get(i).getId());
            if (restoredTask == null) {
                restoredTask = copiedTasks.get(i);
            }
            this.replaceTask(copiedTasks, i, restoredTask);
            if (!(restoredTask instanceof ParallelGroup)) continue;
            List<Task> originalSubTasks = ((ParallelGroup)originalTasks.get(i)).getTasks();
            List<Task> restoredSubTasks = ((ParallelGroup)restoredTask).getTasks();
            this.restoreTasks(originalSubTasks, restoredSubTasks);
        }
    }

    private void replaceTask(List<Task> copiedTasks, int index, Task restoredTask) {
        Task copiedTask = copiedTasks.get(index);
        restoredTask.setId(copiedTask.getId());
        this.replaceNestedCIs(restoredTask, copiedTask);
        this.reset(restoredTask, copiedTask);
        restoredTask.set$token(null);
        this.repositoryService.update((ConfigurationItem[])new Task[]{restoredTask});
        copiedTasks.set(index, restoredTask);
    }

    private void replaceNestedCIs(Task restoredTask, Task copiedTask) {
        restoredTask.setAttachments(copiedTask.getAttachments());
        if (restoredTask instanceof GateTask) {
            ((GateTask)restoredTask).setConditions(((GateTask)copiedTask).getConditions());
            ((GateTask)restoredTask).setDependencies(((GateTask)copiedTask).getDependencies());
        }
        if (restoredTask instanceof ParallelGroup) {
            ((ParallelGroup)restoredTask).setTasks(((ParallelGroup)copiedTask).getTasks());
            ((ParallelGroup)restoredTask).setLinks(((ParallelGroup)copiedTask).getLinks());
        }
        if (restoredTask instanceof CustomScriptTask) {
            CustomScriptTask restoredCustomScriptTask = (CustomScriptTask)restoredTask;
            CustomScriptTask copiedCustomScriptTask = (CustomScriptTask)copiedTask;
            PythonScript copiedPythonScript = copiedCustomScriptTask.getPythonScript();
            restoredCustomScriptTask.setPythonScript(copiedPythonScript);
            copiedPythonScript.setCustomScriptTask(restoredCustomScriptTask);
        }
    }

    private void reset(Task restoredTask, Task copiedTask) {
        restoredTask.setStatus(TaskStatus.PLANNED);
        for (Comment comment : copiedTask.getComments()) {
            this.repositoryService.delete(new String[]{comment.getId()});
        }
        restoredTask.getComments().clear();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        if (restoredTask instanceof GateTask) {
            for (GateCondition condition : ((GateTask)restoredTask).getConditions()) {
                condition.setChecked(false);
                this.repositoryService.update((ConfigurationItem[])new GateCondition[]{condition});
            }
        }
        if (copiedTask instanceof CustomScriptTask) {
            CustomScriptTask copiedCustomScriptTask = (CustomScriptTask)copiedTask;
            PythonScript copiedPythonScript = copiedCustomScriptTask.getPythonScript();
            this.restoreSavedProperties(copiedCustomScriptTask, copiedPythonScript, copiedPythonScript.getPropertiesWithVariables());
            this.restoreSavedProperties(copiedCustomScriptTask, copiedPythonScript, copiedPythonScript.getOutputProperties());
            this.repositoryService.update((ConfigurationItem[])new PythonScript[]{copiedPythonScript});
        }
    }

    private void restoreSavedProperties(CustomScriptTask copiedCustomScriptTask, PythonScript copiedPythonScript, Collection<PropertyDescriptor> properties) {
        Map<String, String> savedVariableProperties = copiedCustomScriptTask.getSavedVariableProperties();
        for (PropertyDescriptor propertyDescriptor : properties) {
            String propertyName = propertyDescriptor.getName();
            copiedPythonScript.setProperty(propertyName, savedVariableProperties.get(propertyName));
        }
    }

    @VisibleForTesting
    void updateGatesReferencingPhases(List<Phase> phasesToRestore, List<Phase> restoredPhases) {
        final Map<PlanItem, PlanItem> originToRestored = this.buildOriginToRestored(phasesToRestore, restoredPhases);
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                List<GateTask> gates = ReleaseEditor.this.tasks.findGatesWithStatus(TaskStatus.PLANNED, TaskStatus.PENDING, TaskStatus.IN_PROGRESS, TaskStatus.FAILED);
                for (GateTask gate : gates) {
                    ReleaseEditor.this.proxyLookup.of(ReleaseEditor.this).updateGateReferencingPhases(gate, originToRestored);
                }
            }
        });
    }

    @Synchronized
    public void updateGateReferencingPhases(@ReleaseIdHolder GateTask gate, Map<PlanItem, PlanItem> originToRestored) {
        for (Dependency dependency : gate.getDependencies()) {
            Object target = (dependency = (Dependency)this.repositoryService.read(dependency.getId())).getTarget();
            if (!originToRestored.containsKey(target)) continue;
            dependency.setTarget(originToRestored.get(target));
            this.repositoryService.update((ConfigurationItem[])new Dependency[]{dependency});
        }
    }

    private Map<PlanItem, PlanItem> buildOriginToRestored(List<Phase> phasesToRestore, List<Phase> restoredPhases) {
        HashMap originToRestored = Maps.newHashMap();
        for (int i = 0; i < phasesToRestore.size(); ++i) {
            Phase originalPhase = phasesToRestore.get(i);
            Phase restoredPhase = restoredPhases.get(i);
            originToRestored.put(originalPhase, restoredPhase);
            List<Task> originalTasks = originalPhase.getAllTasks();
            List<Task> restoredTasks = restoredPhase.getAllTasks();
            for (int j = 0; j < originalTasks.size(); ++j) {
                originToRestored.put(originalTasks.get(j), restoredTasks.get(j));
            }
        }
        return originToRestored;
    }

    @VisibleForTesting
    void updateRelease(Release release, List<Phase> restoredPhases) {
        release.addBelow(release.getCurrentPhase().getId(), restoredPhases);
        release.setStatus(ReleaseStatus.PAUSED);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
    }

    @VisibleForTesting
    void closePhase(Phase currentPhase) {
        ArrayList ciToUpdate = Lists.newArrayList();
        currentPhase.setStatus(PhaseStatus.SKIPPED);
        ciToUpdate.add(currentPhase);
        for (Task task : currentPhase.getAllTasks()) {
            if (task.isDone()) continue;
            task.setStatus(TaskStatus.SKIPPED);
            if (!task.hasStartDate()) {
                task.setStartDate(new Date());
            }
            if (!task.hasEndDate()) {
                task.setEndDate(new Date());
            }
            task.freezeVariables(new Changes(), true);
            ciToUpdate.add(task);
        }
        this.repositoryService.update(ciToUpdate.toArray(new ConfigurationItem[ciToUpdate.size()]));
        this.activityLog.log(Ids.releaseIdFrom(currentPhase.getId()), ReleaseActivity.PHASE_CLOSED.create(currentPhase.getTitle()));
    }
}

