/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.notification.Notifications;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.DeploymentService;
import com.xebialabs.xlrelease.service.PostStartAction;
import com.xebialabs.xlrelease.service.ProxyLookup;
import com.xebialabs.xlrelease.user.User;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutionService {
    private static final int PENDING_TASKS_WATCH_INTERVAL_IN_SECONDS = 15;
    private static final int OVERDUE_TASKS_WATCH_INTERVAL_IN_SECONDS = 60;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionService.class);
    private Notifications notifications;
    private Comments comments;
    private Releases releases;
    private RepositoryService repositoryService;
    private Tasks tasks;
    private Scheduler scheduler;
    private ActivityLog activityLog;
    private DeploymentService deploymentService;
    private DependencyService dependencyService;
    private ScriptService scriptService;
    private ProxyLookup proxyLookup;
    private ScriptLifeCycle scriptLifeCycle;

    @Autowired
    public ExecutionService(Notifications notifications, Comments comments, Releases releases, RepositoryService repositoryService, Tasks tasks, Scheduler scheduler, ActivityLog activityLog, DeploymentService deploymentService, DependencyService dependencyService, ScriptService scriptService, ProxyLookup proxyLookup, ScriptLifeCycle scriptLifeCycle) {
        this.notifications = notifications;
        this.comments = comments;
        this.releases = releases;
        this.repositoryService = repositoryService;
        this.tasks = tasks;
        this.scheduler = scheduler;
        this.activityLog = activityLog;
        this.deploymentService = deploymentService;
        this.dependencyService = dependencyService;
        this.scriptService = scriptService;
        this.proxyLookup = proxyLookup;
        this.scriptLifeCycle = scriptLifeCycle;
    }

    public ExecutionService() {
    }

    public void serverStarted() {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionService.this.reconnectDeployitTasks();
                }
                catch (Exception e) {
                    logger.error("Error during reconnecting of deployit tasks.", (Throwable)e);
                }
            }
        });
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionService.this.notifyOverdueTasks();
                }
                catch (Exception e) {
                    logger.error("Error while notifying overdue tasks.", (Throwable)e);
                }
            }
        }, 0L, 60L, TimeUnit.SECONDS);
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                ExecutionService.this.failInprogressAutomatedTasks();
                ExecutionService.this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExecutionService.this.tryStartingPendingTasks();
                        }
                        catch (Exception e) {
                            logger.error("Error while starting pending tasks.", (Throwable)e);
                        }
                    }
                }, 0L, 15L, TimeUnit.SECONDS);
            }
        });
    }

    @VisibleForTesting
    void failInprogressAutomatedTasks() {
        List<ConfigurationItemData> automatedTasks = this.tasks.findInProgressAutomatedTasks();
        for (ConfigurationItemData task : automatedTasks) {
            logger.info("Task failed: {}. It was interrupted by a server restart.", (Object)task.getId());
            this.fail(task.getId(), "Task failed. It was interrupted by a server restart.", User.SYSTEM);
        }
    }

    private void executePostStartActions(List<PostStartAction> postStartActions) {
        for (PostStartAction action : postStartActions) {
            action.run(this);
        }
    }

    public Release start(String releaseId) {
        Release release = this.releases.findById(releaseId);
        return this.start(release);
    }

    public Release start(Release release) {
        Changes changes = release.start();
        this.updateAndLog(release.getId(), changes, User.AUTHENTICATED_USER);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
        this.notifications.notifyReleaseStarted(release);
        return release;
    }

    public Release resume(String releaseId) {
        Release release = this.releases.findById(releaseId, false);
        Preconditions.checkState((boolean)release.isPaused(), (String)"Only paused releases may be restarted. Release '%s' is %s.", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Changes changes = release.restart();
        this.updateAndLog(releaseId, changes, User.AUTHENTICATED_USER);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
        return release;
    }

    public void startPendingTask(String taskId, String addedComment) {
        Release release = this.releases.containingTask(taskId);
        this.startPendingTask(taskId, release, addedComment, User.AUTHENTICATED_USER);
    }

    @Synchronized
    public void startPendingTask(String taskId, @ReleaseIdHolder Release release, String comment, User user) {
        Changes changes = release.startPendingTask(taskId);
        changes.addComment(taskId, comment);
        this.updateAndLog(release.getId(), changes, user);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
    }

    public void notifyTaskStarted(Task task) {
        this.notifications.notifyTaskStarted(task);
    }

    public void labelLastRevisionAsUnstarted(Task task) {
        this.tasks.labelLastRevisionAsUnstarted(task.getId());
    }

    public void markTaskAsDone(TaskStatus status, String taskId, String addedComment) {
        this.markTaskAsDone(status, taskId, addedComment, User.AUTHENTICATED_USER);
    }

    @Synchronized
    public void markTaskAsDone(TaskStatus targetStatus, @ReleaseIdHolder String taskId, String addedComment, User user) {
        Release release = this.releases.containingTask(taskId);
        this.markTaskAsDone(release, targetStatus, taskId, addedComment, user);
    }

    @Synchronized
    public void scriptTaskCompleted(@ReleaseIdHolder String taskId, String executionLog, String scriptExecutionId) {
        Release release = this.releases.containingTask(taskId);
        BaseScriptTask task = (BaseScriptTask)release.getTask(taskId);
        if (task.isStillExecuting(scriptExecutionId)) {
            this.markTaskAsDone(release, TaskStatus.COMPLETED, taskId, executionLog, User.LOG_OUTPUT);
        } else {
            logger.debug("Will not complete task: '{}', it has been aborted.", (Object)task.getId());
        }
    }

    private void markTaskAsDone(Release release, TaskStatus targetStatus, String taskId, String addedComment, User user) {
        Changes changes = new Changes();
        if (targetStatus.isDoneInAdvance()) {
            Task task = this.tasks.findById(taskId);
            changes.addAll(task.markAsDone(taskId, targetStatus));
        } else {
            changes.addAll(release.markTaskAsDone(taskId, targetStatus));
        }
        changes.addComment(taskId, addedComment);
        this.updateAndLog(release.getId(), changes, user);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
        if (release.isDone()) {
            this.notifications.notifyReleaseCompleted(release);
        }
    }

    public void fail(String taskId, String addedComment) {
        this.fail(taskId, addedComment, User.AUTHENTICATED_USER);
    }

    @Synchronized
    public void fail(@ReleaseIdHolder String taskId, String addedComment, User user) {
        Release release = this.releases.containingTask(taskId);
        this.fail(taskId, addedComment, user, release);
    }

    @Synchronized
    public void scriptTaskFailed(@ReleaseIdHolder String taskId, String scriptFailMessage, String scriptExecutionId) {
        Release release = this.releases.containingTask(taskId);
        BaseScriptTask task = (BaseScriptTask)release.getTask(taskId);
        if (task.isStillExecuting(scriptExecutionId)) {
            this.fail(taskId, FailureReasons.SCRIPT_TASK_FAILED.format(scriptFailMessage), User.LOG_OUTPUT, release);
        } else {
            logger.debug("Will not fail task: '{}', it has been aborted.", (Object)task.getId());
        }
    }

    private void fail(String taskId, String addedComment, User user, Release release) {
        Changes changes = new Changes();
        changes.addAll(release.failTask(taskId, addedComment));
        this.updateAndLog(release.getId(), changes, user);
        this.notifications.notifyTaskFailed(release, this.tasks.findById(taskId));
    }

    public Release abort(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Changes changes = release.abort();
        this.updateAndLog(releaseId, changes, User.AUTHENTICATED_USER);
        this.failDependentGates(changes, release.getTitle());
        this.notifications.notifyReleaseAborted(release);
        return release;
    }

    public void retry(String taskId, String addedComment) {
        Release release = this.releases.containingTask(taskId);
        Changes changes = release.retryTask(taskId);
        changes.addComment(taskId, addedComment);
        this.updateAndLog(release.getId(), changes, User.AUTHENTICATED_USER);
        this.executePostStartActions(changes.getPostStartActions());
    }

    public void abortTask(String taskId, String addedComment) {
        this.fail(taskId, FailureReasons.SCRIPT_TASK_ABORTED.format(addedComment));
        BaseScriptTask task = (BaseScriptTask)this.tasks.findById(taskId);
        this.scriptLifeCycle.tryAborting(task.getExecutionId());
    }

    public void reopenTask(String taskId, String addedComment) {
        Task task = this.tasks.findById(taskId);
        Changes changes = task.reopen();
        changes.addComment(taskId, addedComment);
        this.updateAndLog(Ids.releaseIdFrom(taskId), changes, User.AUTHENTICATED_USER);
    }

    private void completeDependentGates(Changes changes) {
        Collection<GateTask> completableGates = this.dependencyService.getCompletableGates(this.toPlanItems(changes.getUpdatedItems()));
        for (final GateTask gate : completableGates) {
            this.scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExecutionService.this.proxyLookup.of(ExecutionService.this).markTaskAsDone(TaskStatus.COMPLETED, gate.getId(), null, User.SYSTEM);
                    }
                    catch (Exception e) {
                        logger.error("Error while completing dependent gate " + gate.getId(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void failDependentGates(Changes changes, final String releaseTitle) {
        Collection<GateTask> failableGates = this.dependencyService.getFailableGates(this.toPlanItems(changes.getUpdatedItems()));
        for (final GateTask gate : failableGates) {
            this.scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExecutionService.this.proxyLookup.of(ExecutionService.this).fail(gate.getId(), FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(releaseTitle), User.SYSTEM);
                    }
                    catch (Exception e) {
                        logger.error("Error while failing dependent gate " + gate.getId(), (Throwable)e);
                    }
                }
            });
        }
    }

    private Set<PlanItem> toPlanItems(Set<ConfigurationItem> updatedItems) {
        HashSet<PlanItem> planItems = new HashSet<PlanItem>();
        for (ConfigurationItem updatedItem : updatedItems) {
            if (!(updatedItem instanceof PlanItem)) continue;
            planItems.add((PlanItem)updatedItem);
        }
        return planItems;
    }

    private void updateAndLog(String releaseId, Changes changes, User user) {
        this.repositoryService.update(changes.toUpdatedItemsArray());
        this.activityLog.log(releaseId, changes.getActivityLogEntries(), user);
        for (Map.Entry entry : changes.getCommentsByTaskId().entries()) {
            String addedComment = (String)entry.getValue();
            this.comments.create((String)entry.getKey(), addedComment, user, false);
        }
    }

    @VisibleForTesting
    void reconnectDeployitTasks() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(DeployitTask.class)).addProperty("status", TaskStatus.IN_PROGRESS.name());
        List tasks = this.repositoryService.listEntities(query);
        for (DeployitTask task : tasks) {
            logger.info("Reconnecting deployit task '{}'", (Object)task.getId());
            this.deploy(task);
        }
    }

    public void deploy(final DeployitTask task) {
        Runnable onSuccess = new Runnable(){

            @Override
            public void run() {
                logger.info("Deployment task '{}' successfully executed.", (Object)task.getId());
                ExecutionService.this.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
            }
        };
        Runnable onFailure = new Runnable(){

            @Override
            public void run() {
                logger.info("Deployment task '{}' failed.", (Object)task.getId());
                ExecutionService.this.proxyLookup.of(ExecutionService.this).fail(task.getId(), FailureReasons.DEPLOYMENT_TASK_FAILED.format(new Object[0]), User.SYSTEM);
                ExecutionService.this.deploymentService.rollbackAsynchronously(task.getId());
            }
        };
        Runnable onException = new Runnable(){

            @Override
            public void run() {
                ExecutionService.this.proxyLookup.of(ExecutionService.this).fail(task.getId(), FailureReasons.DEPLOYMENT_TASK_FAILED.format(new Object[0]), User.SYSTEM);
            }
        };
        this.deploymentService.deployAsynchronously(task, onSuccess, onFailure, onException);
    }

    public void sendNotification(final NotificationTask task) {
        Runnable onSuccess = new Runnable(){

            @Override
            public void run() {
                ExecutionService.this.proxyLookup.of(ExecutionService.this).markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
            }
        };
        Runnable onException = new Runnable(){

            @Override
            public void run() {
                ExecutionService.this.proxyLookup.of(ExecutionService.this).fail(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[0]), User.SYSTEM);
            }
        };
        this.notifications.executeNotificationTask(task, onSuccess, onException);
    }

    public void executeScript(ScriptTask task) {
        this.scriptService.executeScriptTask(task, this.getOnSuccessScriptCallBack(task), this.getOnFailureScriptCallBack(task));
    }

    public void executeCustomScript(CustomScriptTask task) {
        this.scriptService.executeCustomScriptTask(task, this.getOnSuccessScriptCallBack(task), this.getOnFailureScriptCallBack(task));
    }

    @VisibleForTesting
    ScriptCallback getOnSuccessScriptCallBack(final BaseScriptTask task) {
        return new ScriptCallback(){

            @Override
            public void run() {
                ExecutionService.this.proxyLookup.of(ExecutionService.this).scriptTaskCompleted(task.getId(), this.getExecutionLog(), task.getExecutionId());
            }
        };
    }

    @VisibleForTesting
    ScriptCallback getOnFailureScriptCallBack(final BaseScriptTask task) {
        return new ScriptCallback(){

            @Override
            public void run() {
                ExecutionService.this.proxyLookup.of(ExecutionService.this).scriptTaskFailed(task.getId(), this.getExecutionLog(), task.getExecutionId());
            }
        };
    }

    @VisibleForTesting
    void tryStartingPendingTasks() {
        List<Task> pendingTasks = this.tasks.findPendingTasks();
        for (Task task : pendingTasks) {
            if (!task.canStartNow()) continue;
            this.proxyLookup.of(this).startPendingTask(task.getId(), task.getRelease(), null, User.SYSTEM);
        }
    }

    @VisibleForTesting
    void notifyOverdueTasks() {
        List<Task> activeTasks = this.tasks.findTasksWithStatus(TaskStatus.IN_PROGRESS);
        for (Task task : activeTasks) {
            Date startDate = task.getStartDate();
            Date dueDate = task.getDueDate();
            if (!task.isOverdue() || !startDate.before(dueDate) || task.isOverdueNotified()) continue;
            this.notifications.notifyTaskOverdue(task);
            this.proxyLookup.of(this).markTaskAsNotified(task.getId());
        }
    }

    @Synchronized
    public void markTaskAsNotified(@ReleaseIdHolder String taskId) {
        Task task = (Task)this.repositoryService.read(taskId);
        task.setOverdueNotified(true);
        this.repositoryService.update((ConfigurationItem[])new Task[]{task});
    }
}

