/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.repository.Tasks;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DependencyService {
    private Tasks tasks;
    private static final Predicate<PlanItem> IS_DONE = new Predicate<PlanItem>(){

        public boolean apply(PlanItem target) {
            return target.isDone();
        }
    };
    private static final Predicate<GateTask> IS_COMPLETABLE = new Predicate<GateTask>(){

        public boolean apply(GateTask gateTask) {
            return gateTask.isCompletable();
        }
    };

    @Autowired
    public DependencyService(Tasks tasks) {
        this.tasks = tasks;
    }

    public Collection<GateTask> getCompletableGates(Set<PlanItem> targets) {
        List<GateTask> activeGates = this.tasks.findActiveGates();
        Set doneTargets = Sets.filter(targets, IS_DONE);
        Predicate<GateTask> withDependencyOnOneTarget = this.getDependentGatePredicate(doneTargets);
        return Collections2.filter(activeGates, (Predicate)Predicates.and(withDependencyOnOneTarget, IS_COMPLETABLE));
    }

    public Collection<GateTask> getFailableGates(Set<PlanItem> abortedTargets) {
        List<GateTask> activeGates = this.tasks.findActiveGates();
        Predicate<GateTask> withDependencyOnOneTarget = this.getDependentGatePredicate(abortedTargets);
        return Collections2.filter(activeGates, withDependencyOnOneTarget);
    }

    public Collection<GateTask> findIncomingDependencies(Release release) {
        Collection<PlanItem> planItems = release.getAllPlanItems();
        planItems = Collections2.filter(planItems, (Predicate)Predicates.not(IS_DONE));
        List<GateTask> gates = this.tasks.findGatesWithStatus(TaskStatus.PLANNED, TaskStatus.IN_PROGRESS, TaskStatus.PENDING, TaskStatus.FAILED);
        Predicate<GateTask> withDependencyOnOneTarget = this.getDependentGatePredicate(Sets.newHashSet(planItems));
        return Collections2.filter(gates, withDependencyOnOneTarget);
    }

    private Predicate<GateTask> getDependentGatePredicate(final Set<PlanItem> targets) {
        Predicate<Dependency> referencingOneTarget = new Predicate<Dependency>(){

            public boolean apply(Dependency dependency) {
                return targets.contains(dependency.getTarget());
            }
        };
        return new Predicate<GateTask>((Predicate)referencingOneTarget){
            final /* synthetic */ Predicate val$referencingOneTarget;
            {
                this.val$referencingOneTarget = predicate;
            }

            public boolean apply(GateTask gateTask) {
                return !Collections2.filter(gateTask.getDependencies(), (Predicate)this.val$referencingOneTarget).isEmpty();
            }
        };
    }
}

