/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.userdata.UserData;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserProfiles {
    public static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users";
    private RepositoryService repositoryService;
    private UserDataProvider userDataProvider;
    private LoadingCache<String, Optional<UserProfile>> userProfilesCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Optional<UserProfile>>(){

        public Optional<UserProfile> load(String canonicalId) throws Exception {
            SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class)).addProperty("canonicalId", canonicalId);
            List profiles = UserProfiles.this.repositoryService.listEntities(query);
            if (profiles.size() > 0) {
                return Optional.of(profiles.get(0));
            }
            return Optional.absent();
        }
    });

    @Autowired
    public UserProfiles(RepositoryService repositoryService, UserDataProvider userDataProvider) {
        this.repositoryService = repositoryService;
        this.userDataProvider = userDataProvider;
    }

    public UserProfile findByUsername(String username) {
        try {
            return (UserProfile)((Object)((Optional)this.userProfilesCache.get((Object)this.toCanonicalId(username))).orNull());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<UserProfile> findAll() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class));
        return this.repositoryService.listEntities(query);
    }

    public String getNotificationEmail(String username) {
        if (UserProfiles.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.getOrCreate(username, false);
        return profile == null ? null : profile.getEmail();
    }

    public String getFullName(String username) {
        if (UserProfiles.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.getOrCreate(username, false);
        return profile == null ? null : profile.getFullName();
    }

    public String getFullNameOrUsername(String username) {
        String fullName = this.getFullName(username);
        return UserProfiles.isUndefined(fullName) ? username : fullName;
    }

    public boolean exists(String username) {
        return this.findByUsername(username) != null;
    }

    public void ensureCreated(String username) {
        this.getOrCreate(username, true);
    }

    private UserProfile getOrCreate(String username, boolean createIfNotFound) {
        UserProfile profile;
        boolean needsSave = false;
        if (this.exists(username)) {
            profile = this.findByUsername(username);
        } else {
            UserData userData = this.userDataProvider.getUserData(username);
            if (userData.isFound() || createIfNotFound) {
                String id = this.buildId(username);
                profile = new UserProfile(id, userData.getEmail(), userData.getFullName());
                needsSave = true;
            } else {
                profile = null;
            }
        }
        if (needsSave) {
            this.save(profile);
        }
        return profile;
    }

    public void save(UserProfile profile) {
        this.ensureRootDirExists();
        this.repositoryService.createOrUpdate((ConfigurationItem[])new UserProfile[]{profile});
        this.userProfilesCache.invalidate((Object)profile.getCanonicalId());
    }

    public void delete(String username) {
        String id = this.buildId(username);
        this.repositoryService.delete(new String[]{id});
        this.userProfilesCache.invalidate((Object)this.toCanonicalId(id));
    }

    public String buildId(String username) {
        return ROOT + "/" + username;
    }

    public void clearCache() {
        this.userProfilesCache.invalidateAll();
    }

    private void ensureRootDirExists() {
        if (!this.repositoryService.exists(ROOT)) {
            Directory directory = new Directory();
            directory.setId(ROOT);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }

    private static boolean isUndefined(String username) {
        return com.xebialabs.deployit.booter.local.utils.Strings.isEmpty((String)Strings.nullToEmpty((String)username).trim());
    }

    private String toCanonicalId(String username) {
        return username.toLowerCase();
    }
}

