/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.reports.Duration;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseDuration;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.TaskWithReleaseData;
import com.xebialabs.xlrelease.reports.UserTask;
import com.xebialabs.xlrelease.repository.JcrPredicate;
import com.xebialabs.xlrelease.repository.JcrQueryBuilder;
import com.xebialabs.xlrelease.repository.JcrQueryExecutorForList;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.TimeFrame;
import com.xebialabs.xlrelease.views.UserView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Reports {
    private JcrTemplate jcrTemplate;
    private UserProfiles userProfiles;

    @Autowired
    public Reports(JcrTemplate jcrTemplate, UserProfiles userProfiles) {
        this.jcrTemplate = jcrTemplate;
        this.userProfiles = userProfiles;
    }

    public List<UserTask> getUsersTasks(TimeFrame timeFrame, final Iterable<String> tags, final Date from, final Date to) {
        return new JcrQueryExecutorForList<UserTask>(this.jcrTemplate, timeFrame){

            @Override
            public String query(TimeFrame timeFrame) {
                return JcrQueryBuilder.select("task.owner", "task.title", "task.startDate", "task.endDate").from("task").joinWithParent("task", "release").where(JcrPredicate.and(JcrPredicate.as("task", Task.class), JcrPredicate.as("release", Release.class), JcrPredicate.or(JcrPredicate.equal("task.status", TaskStatus.COMPLETED.name()), JcrPredicate.equal("task.status", TaskStatus.COMPLETED_IN_ADVANCE.name())), JcrPredicate.equal("release.tutorial", Boolean.FALSE.toString()), JcrPredicate.greaterThan("task.endDate", timeFrame.getStartDate(from)), JcrPredicate.lowerThan("task.startDate", timeFrame.getEndDate(to)), JcrPredicate.containsAtLeastOne("release.tags", tags))).toString();
            }

            @Override
            public UserTask transform(Row row) throws RepositoryException {
                String username = row.getValue("task.owner").getString();
                UserView user = new UserView(username, Reports.this.userProfiles);
                return new UserTask(user, row.getValue("task.startDate").getDate(), row.getValue("task.endDate").getDate());
            }
        }.getList();
    }

    public List<TaskDuration> getTasksDuration(TimeFrame timeFrame, final Iterable<String> tags, final Date from, final Date to) {
        return new JcrQueryExecutorForList<TaskDuration>(this.jcrTemplate, timeFrame){

            @Override
            public String query(TimeFrame timeFrame) {
                return JcrQueryBuilder.select("task.owner", "task.title", "task.startDate", "task.endDate", "task.team", "phase.title", "release.title").from("task").joinWithParent("task", "phase").joinWithParent("phase", "release").where(JcrPredicate.and(JcrPredicate.notNull("release.title"), JcrPredicate.as("task", Task.class), JcrPredicate.as("phase", Phase.class), JcrPredicate.as("release", Release.class), JcrPredicate.or(JcrPredicate.equal("task.status", TaskStatus.COMPLETED.name()), JcrPredicate.equal("task.status", TaskStatus.COMPLETED_IN_ADVANCE.name())), JcrPredicate.equal("release.tutorial", Boolean.FALSE.toString()), JcrPredicate.greaterThan("task.endDate", timeFrame.getStartDate(from)), JcrPredicate.lowerThan("task.startDate", timeFrame.getEndDate(to)), JcrPredicate.containsAtLeastOne("release.tags", tags))).toString();
            }

            @Override
            public TaskDuration transform(Row row) throws RepositoryException {
                DateTime startDate = new DateTime((Object)row.getValue("task.startDate").getDate().getTime());
                DateTime endDate = new DateTime((Object)row.getValue("task.endDate").getDate().getTime());
                TaskDuration taskDuration = new TaskDuration();
                taskDuration.setDuration(new Duration(startDate, endDate).compute());
                String username = row.getValue("task.owner").getString();
                UserView user = new UserView(username, Reports.this.userProfiles);
                taskDuration.setOwner(user);
                taskDuration.setTeam(row.getValue("task.team").getString());
                taskDuration.setTitle(row.getValue("task.title").getString());
                taskDuration.setPhase(row.getValue("phase.title").getString());
                taskDuration.setRelease(row.getValue("release.title").getString());
                taskDuration.setReleaseId(Reports.this.toApplicationId(row.getPath("release")));
                return taskDuration;
            }
        }.getList();
    }

    public List<TaskWithReleaseData> getReleaseAutomationData(TimeFrame timeFrame, final Iterable<String> tags, final Date from, final Date to) {
        return new JcrQueryExecutorForList<TaskWithReleaseData>(this.jcrTemplate, timeFrame){

            @Override
            public String query(TimeFrame timeFrame) {
                return JcrQueryBuilder.select("task.title", "task.startDate", "task.endDate", "release.title", "release.endDate", "release.title", "release.status").selectTypeAs("task", "taskType").from("task").joinWithParent("task", "release").where(JcrPredicate.and(JcrPredicate.as("task", Task.class), JcrPredicate.as("release", Release.class), JcrPredicate.equal("release.status", ReleaseStatus.COMPLETED.name()), JcrPredicate.equal("release.tutorial", Boolean.FALSE.toString()), JcrPredicate.greaterThan("task.endDate", timeFrame.getStartDate(from)), JcrPredicate.lowerThan("task.startDate", timeFrame.getEndDate(to)), JcrPredicate.containsAtLeastOne("release.tags", tags))).orderBy("release.endDate").toString();
            }

            @Override
            public TaskWithReleaseData transform(Row row) throws RepositoryException {
                TaskWithReleaseData task = new TaskWithReleaseData();
                task.setTitle(row.getValue("task.title").getString());
                task.setAutomated(Reports.this.isAutomatedType(row.getValue("taskType").getString()));
                task.setStartDate(row.getValue("task.startDate").getDate());
                task.setEndDate(row.getValue("task.endDate").getDate());
                task.setReleaseId(row.getPath("release"));
                task.setReleaseTitle(row.getValue("release.title").getString());
                task.setReleaseEndDate(row.getValue("release.endDate").getDate());
                return task;
            }
        }.getList();
    }

    public List<PhaseDuration> getPhasesDuration(TimeFrame timeFrame, final Iterable<String> tags, final Date from, final Date to) {
        return new JcrQueryExecutorForList<PhaseDuration>(this.jcrTemplate, timeFrame){

            @Override
            public String query(TimeFrame timeFrame) {
                return JcrQueryBuilder.select("phase.title", "phase.startDate", "phase.endDate", "release.title").from("phase").joinWithParent("phase", "release").where(JcrPredicate.and(JcrPredicate.as("phase", Phase.class), JcrPredicate.as("release", Release.class), JcrPredicate.equal("phase.status", PhaseStatus.COMPLETED.name()), JcrPredicate.equal("release.tutorial", Boolean.FALSE.toString()), JcrPredicate.notNull("release.title"), JcrPredicate.greaterThan("phase.endDate", timeFrame.getStartDate(from)), JcrPredicate.lowerThan("phase.startDate", timeFrame.getEndDate(to)), JcrPredicate.containsAtLeastOne("release.tags", tags))).toString();
            }

            @Override
            public PhaseDuration transform(Row row) throws RepositoryException {
                PhaseDuration phase = new PhaseDuration();
                phase.setTitle(row.getValue("phase.title").getString());
                phase.setRelease(row.getValue("release.title").getString());
                phase.setReleaseId(Reports.this.toApplicationId(row.getPath("release")));
                DateTime startDate = new DateTime((Object)row.getValue("phase.startDate").getDate().getTime());
                DateTime endDate = new DateTime((Object)row.getValue("phase.endDate").getDate().getTime());
                phase.setDuration(new Duration(startDate, endDate).compute());
                return phase;
            }
        }.getList();
    }

    public List<DateTime> getReleasesEndDate(TimeFrame timeFrame, final Iterable<String> tags, final Date from, final Date to) {
        return new JcrQueryExecutorForList<DateTime>(this.jcrTemplate, timeFrame){

            @Override
            public String query(TimeFrame timeFrame) {
                return JcrQueryBuilder.select("endDate").from("release").where(JcrPredicate.and(JcrPredicate.equal("release.status", ReleaseStatus.COMPLETED.name()), JcrPredicate.equal("release.tutorial", Boolean.FALSE.toString()), JcrPredicate.as("release", Release.class), JcrPredicate.greaterThan("endDate", timeFrame.getStartDate(from)), JcrPredicate.lowerThan("startDate", timeFrame.getEndDate(to)), JcrPredicate.containsAtLeastOne("release.tags", tags))).orderBy("endDate").toString();
            }

            @Override
            public DateTime transform(Row row) throws RepositoryException {
                return new DateTime((Object)row.getValue("endDate").getDate().getTime());
            }
        }.getList();
    }

    public List<ReleaseDuration> getReleasesDuration(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        List<ReleaseDuration> releasesDuration = this.getCompletedReleases(timeFrame, tags, from, to);
        this.computeAutomations(releasesDuration);
        return releasesDuration;
    }

    private List<ReleaseDuration> getCompletedReleases(TimeFrame timeFrame, final Iterable<String> tags, final Date from, final Date to) {
        return new JcrQueryExecutorForList<ReleaseDuration>(this.jcrTemplate, timeFrame){

            @Override
            public String query(TimeFrame timeFrame) {
                return JcrQueryBuilder.select("title", "startDate", "endDate").from("release").where(JcrPredicate.and(JcrPredicate.as("release", Release.class), JcrPredicate.equal("release.status", ReleaseStatus.COMPLETED.name()), JcrPredicate.equal("release.tutorial", Boolean.FALSE.toString()), JcrPredicate.greaterThan("release.endDate", timeFrame.getStartDate(from)), JcrPredicate.lowerThan("release.startDate", timeFrame.getEndDate(to)), JcrPredicate.containsAtLeastOne("release.tags", tags))).orderBy("endDate").toString();
            }

            @Override
            public ReleaseDuration transform(Row row) throws RepositoryException {
                ReleaseDuration releaseDuration = new ReleaseDuration();
                releaseDuration.setReleaseId(row.getPath());
                releaseDuration.setTitle(row.getValue("title").getString());
                DateTime startDate = new DateTime((Object)row.getValue("startDate").getDate().getTime());
                DateTime endDate = new DateTime((Object)row.getValue("endDate").getDate().getTime());
                releaseDuration.setDuration(new Duration(startDate, endDate).compute());
                releaseDuration.setEndDate(endDate);
                return releaseDuration;
            }
        }.getList();
    }

    private void computeAutomations(List<ReleaseDuration> releasesDuration) {
        for (ReleaseDuration releaseDuration : releasesDuration) {
            releaseDuration.setWithAutomation(this.hasAutomatedTask(releaseDuration.getReleaseId()));
            releaseDuration.setReleaseId(this.toApplicationId(releaseDuration.getReleaseId()));
        }
    }

    private boolean hasAutomatedTask(final String releaseId) {
        return (Boolean)this.jcrTemplate.execute((JcrCallback)new JcrCallback<Boolean>(){

            public Boolean doInJcr(Session session) throws RepositoryException {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.buildQuery(), "JCR-SQL2");
                QueryResult queryResult = query.execute();
                RowIterator rows = queryResult.getRows();
                return rows.hasNext();
            }

            private String buildQuery() {
                return JcrQueryBuilder.select("title").from("task").where(JcrPredicate.and(JcrPredicate.isInPath("task", releaseId), Reports.this.isAutomated("task"))).toString();
            }
        });
    }

    protected List<Type> getAutomatedTaskTypes() {
        ArrayList types = Lists.newArrayList();
        for (Type subtype : DescriptorRegistry.getSubtypes((Type)Type.valueOf(Task.class))) {
            if (!subtype.getDescriptor().getPropertyDescriptor("automated").getDefaultValue().toString().equals("true") || subtype.instanceOf(Type.valueOf(ParallelGroup.class))) continue;
            types.add(subtype);
        }
        return types;
    }

    protected String isAutomated(final String selector) {
        Collection predicates = Collections2.transform(this.getAutomatedTaskTypes(), (Function)new Function<Type, String>(){

            public String apply(Type type) {
                return JcrPredicate.getTypePredicate(selector, type);
            }
        });
        return JcrPredicate.or(predicates.toArray(new String[predicates.size() - 1]));
    }

    private boolean isAutomatedType(String taskType) throws RepositoryException {
        Collection automatedTaskTypes = Collections2.transform(this.getAutomatedTaskTypes(), (Function)new Function<Type, String>(){

            public String apply(Type type) {
                return type.toString();
            }
        });
        return automatedTaskTypes.contains(taskType);
    }

    private String toApplicationId(String jcrId) {
        return jcrId.substring(1);
    }
}

