/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.activity.PhaseFieldsComparator;
import com.xebialabs.xlrelease.builder.PhaseBuilder;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.PhaseForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Phases
extends AbstractRepository {
    private ActivityLog activityLog;
    private static final String DEFAULT_TITLE = "New Phase";

    @Autowired
    public Phases(RepositoryService repositoryService, ActivityLog activityLog) {
        super(repositoryService);
        this.activityLog = activityLog;
    }

    @Override
    protected String getEntityPrefix() {
        return "Phase";
    }

    public Phase create(String parentId) {
        return this.create(parentId, DEFAULT_TITLE);
    }

    public Phase create(String parentId, String phaseTitle) {
        Release release = (Release)this.repositoryService.read(parentId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (Object)"You can't add phase to a finished release");
        Phase newPhase = PhaseBuilder.newPhase().withId(this.getUniqueId(parentId)).withTitle(phaseTitle).withStatus(PhaseStatus.PLANNED).build();
        this.repositoryService.create((ConfigurationItem[])new Phase[]{newPhase});
        this.activityLog.log(parentId, ReleaseActivity.PHASE_CREATED.create(phaseTitle));
        return newPhase;
    }

    public Phase findById(String phaseId) {
        return (Phase)this.repositoryService.read(phaseId);
    }

    public void delete(String phaseId) {
        Phase phase = (Phase)this.repositoryService.read(phaseId);
        Preconditions.checkArgument((boolean)phase.isPlanned(), (Object)"Only planned phases can be deleted");
        this.repositoryService.delete(new String[]{phaseId});
        this.activityLog.log(Ids.releaseIdFrom(phaseId), ReleaseActivity.PHASE_DELETED.create(phase.getTitle()));
    }

    public Phase update(String phaseId, PhaseForm phaseForm) {
        Phase phase = (Phase)this.repositoryService.read(phaseId);
        Preconditions.checkArgument((boolean)phase.isUpdatable(), (String)"The phase '%s' can't be updated because it has finished.", (Object[])new Object[]{phase.getTitle()});
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(phase, phaseForm), (String)"The start date of '%s' can't be updated because this phase has already started.", (Object[])new Object[]{phase.getTitle()});
        List<ActivityLogEntry> logEntries = new PhaseFieldsComparator(phase, phaseForm).getLogs();
        Changes changes = new Changes();
        changes.update((ConfigurationItem)phase);
        if (phaseForm.getTitle() != null) {
            Preconditions.checkArgument((!phaseForm.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Phase title is required.");
            phase.setTitle(phaseForm.getTitle());
        }
        phase.setDescription(phaseForm.getDescription());
        phase.setColor(phaseForm.getColor());
        phase.updateDates(phaseForm.getScheduledStartDate(), phaseForm.getDueDate(), phaseForm.getPlannedDuration());
        this.repositoryService.update(changes.toUpdatedItemsArray());
        this.activityLog.log(Ids.releaseIdFrom(phaseId), logEntries, User.AUTHENTICATED_USER);
        return phase;
    }

    private boolean isScheduledStartDateUpdatable(Phase phase, PhaseForm updatedPhase) {
        return phase.isPlanned() || Objects.equal((Object)phase.getScheduledStartDate(), (Object)updatedPhase.getScheduledStartDate());
    }
}

